/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.BindableMongoExpression;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationPipeline;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class MongoAotRepositoryFragmentSupport {
    private final RepositoryMetadata repositoryMetadata;
    private final MongoOperations mongoOperations;
    private final MongoConverter mongoConverter;
    private final ProjectionFactory projectionFactory;

    protected MongoAotRepositoryFragmentSupport(MongoOperations mongoOperations, RepositoryFactoryBeanSupport.FragmentCreationContext context) {
        this(mongoOperations, context.getRepositoryMetadata(), context.getProjectionFactory());
    }

    protected MongoAotRepositoryFragmentSupport(MongoOperations mongoOperations, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory) {
        this.mongoOperations = mongoOperations;
        this.mongoConverter = mongoOperations.getConverter();
        this.repositoryMetadata = repositoryMetadata;
        this.projectionFactory = projectionFactory;
    }

    protected Document bindParameters(String source, Object[] parameters) {
        return new BindableMongoExpression(source, this.mongoConverter, parameters).toDocument();
    }

    protected BasicQuery createQuery(String queryString, Object[] parameters) {
        Document queryDocument = this.bindParameters(queryString, parameters);
        return new BasicQuery(queryDocument);
    }

    protected AggregationPipeline createPipeline(List<Object> rawStages) {
        ArrayList<AggregationOperation> stages = new ArrayList<AggregationOperation>(rawStages.size());
        boolean first = true;
        for (Object rawStage : rawStages) {
            if (rawStage instanceof Document) {
                Document stageDocument = (Document)rawStage;
                if (first) {
                    stages.add(ctx -> ctx.getMappedObject(stageDocument));
                } else {
                    stages.add(ctx -> stageDocument);
                }
            } else if (rawStage instanceof AggregationOperation) {
                AggregationOperation aggregationOperation = (AggregationOperation)rawStage;
                stages.add(aggregationOperation);
            } else {
                throw new RuntimeException("%s cannot be converted to AggregationOperation".formatted(rawStage.getClass()));
            }
            if (!first) continue;
            first = false;
        }
        return new AggregationPipeline(stages);
    }

    protected List<Object> convertSimpleRawResults(Class<?> targetType, List<Document> rawResults) {
        ArrayList<Object> list = new ArrayList<Object>(rawResults.size());
        for (Document it : rawResults) {
            list.add(MongoAotRepositoryFragmentSupport.extractSimpleTypeResult(it, targetType, this.mongoConverter));
        }
        return list;
    }

    protected @Nullable Object convertSimpleRawResult(Class<?> targetType, Document rawResult) {
        return MongoAotRepositoryFragmentSupport.extractSimpleTypeResult(rawResult, targetType, this.mongoConverter);
    }

    private static <T> @Nullable T extractSimpleTypeResult(@Nullable Document source, Class<T> targetType, MongoConverter converter) {
        if (ObjectUtils.isEmpty((Object)source)) {
            return null;
        }
        if (source.size() == 1) {
            return MongoAotRepositoryFragmentSupport.getPotentiallyConvertedSimpleTypeValue(converter, source.values().iterator().next(), targetType);
        }
        Document intermediate = new Document((Map)source);
        intermediate.remove((Object)FieldName.ID.name());
        if (intermediate.size() == 1) {
            return MongoAotRepositoryFragmentSupport.getPotentiallyConvertedSimpleTypeValue(converter, intermediate.values().iterator().next(), targetType);
        }
        for (Map.Entry entry : intermediate.entrySet()) {
            if (entry == null || !ClassUtils.isAssignable(targetType, entry.getValue().getClass())) continue;
            return targetType.cast(entry.getValue());
        }
        throw new IllegalArgumentException(String.format("o_O no entry of type %s found in %s.", targetType.getSimpleName(), source.toJson()));
    }

    private static <T> @Nullable T getPotentiallyConvertedSimpleTypeValue(MongoConverter converter, @Nullable Object value, Class<T> targetType) {
        if (value == null) {
            return null;
        }
        if (ClassUtils.isAssignableValue(targetType, (Object)value)) {
            return (T)value;
        }
        return (T)converter.getConversionService().convert(value, targetType);
    }
}

