/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import org.bson.BsonBinary;
import org.bson.BsonDbPointer;
import org.bson.BsonReader;
import org.bson.BsonRegularExpression;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.jspecify.annotations.NullUnmarked;
import org.springframework.util.StringUtils;

@NullUnmarked
class SpringJsonWriter
implements BsonWriter {
    private final StringBuffer buffer;
    private JsonContext context = new JsonContext(null, JsonContextType.TOP_LEVEL);
    private State state = State.INITIAL;

    public SpringJsonWriter(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public void flush() {
    }

    public void writeBinaryData(BsonBinary binary) {
        this.preWriteValue();
        this.writeStartDocument();
        this.writeName("$binary");
        this.writeStartDocument();
        this.writeName("base64");
        this.writeString(Base64.getEncoder().encodeToString(binary.getData()));
        this.writeName("subType");
        this.writeInt32(binary.getBsonType().getValue());
        this.writeEndDocument();
        this.writeEndDocument();
    }

    public void writeBinaryData(String name, BsonBinary binary) {
        this.writeName(name);
        this.writeBinaryData(binary);
    }

    public void writeBoolean(boolean value) {
        this.preWriteValue();
        this.write(value ? "true" : "false");
        this.setNextState();
    }

    public void writeBoolean(String name, boolean value) {
        this.writeName(name);
        this.writeBoolean(value);
    }

    public void writeDateTime(long value) {
        this.writeStartDocument();
        this.writeName("$date");
        this.writeString(ZonedDateTime.ofInstant(Instant.ofEpochMilli(value), ZoneId.of("Z")).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        this.writeEndDocument();
    }

    public void writeDateTime(String name, long value) {
        this.writeName(name);
        this.writeDateTime(value);
    }

    public void writeDBPointer(BsonDbPointer value) {
    }

    public void writeDBPointer(String name, BsonDbPointer value) {
    }

    public void writeDouble(double value) {
        this.writeStartDocument();
        this.writeName("$numberDouble");
        this.writeString(Double.valueOf(value).toString());
        this.writeEndDocument();
    }

    public void writeDouble(String name, double value) {
        this.writeName(name);
        this.writeDouble(value);
    }

    public void writeEndArray() {
        this.write("]");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    public void writeEndDocument() {
        this.buffer.append("}");
        this.context = this.context.parentContext;
        if (this.context.contextType == JsonContextType.TOP_LEVEL) {
            this.state = State.DONE;
        } else {
            this.setNextState();
        }
    }

    public void writeInt32(int value) {
        this.writeStartDocument();
        this.writeName("$numberInt");
        this.writeString(Integer.valueOf(value).toString());
        this.writeEndDocument();
    }

    public void writeInt32(String name, int value) {
        this.writeName(name);
        this.writeInt32(value);
    }

    public void writeInt64(long value) {
        this.writeStartDocument();
        this.writeName("$numberLong");
        this.writeString(Long.valueOf(value).toString());
        this.writeEndDocument();
    }

    public void writeInt64(String name, long value) {
        this.writeName(name);
        this.writeInt64(value);
    }

    public void writeDecimal128(Decimal128 value) {
        this.writeStartDocument();
        this.writeName("$numberDecimal");
        this.writeString(value.toString());
        this.writeEndDocument();
    }

    public void writeDecimal128(String name, Decimal128 value) {
        this.writeName(name);
        this.writeDecimal128(value);
    }

    public void writeJavaScript(String code) {
        this.writeStartDocument();
        this.writeName("$code");
        this.writeString(code);
        this.writeEndDocument();
    }

    public void writeJavaScript(String name, String code) {
        this.writeName(name);
        this.writeJavaScript(code);
    }

    public void writeJavaScriptWithScope(String code) {
    }

    public void writeJavaScriptWithScope(String name, String code) {
    }

    public void writeMaxKey() {
        this.writeStartDocument();
        this.writeName("$maxKey");
        this.buffer.append(1);
        this.writeEndDocument();
    }

    public void writeMaxKey(String name) {
        this.writeName(name);
        this.writeMaxKey();
    }

    public void writeMinKey() {
        this.writeStartDocument();
        this.writeName("$minKey");
        this.buffer.append(1);
        this.writeEndDocument();
    }

    public void writeMinKey(String name) {
        this.writeName(name);
        this.writeMinKey();
    }

    public void writeName(String name) {
        if (this.context.hasElements) {
            this.write(",");
        } else {
            this.context.hasElements = true;
        }
        this.writeString(name);
        this.buffer.append(":");
        this.state = State.VALUE;
    }

    public void writeNull() {
        this.buffer.append("null");
    }

    public void writeNull(String name) {
        this.writeName(name);
        this.writeNull();
    }

    public void writeObjectId(ObjectId objectId) {
        this.writeStartDocument();
        this.writeName("$oid");
        this.writeString(objectId.toHexString());
        this.writeEndDocument();
    }

    public void writeObjectId(String name, ObjectId objectId) {
        this.writeName(name);
        this.writeObjectId(objectId);
    }

    public void writeRegularExpression(BsonRegularExpression regularExpression) {
        this.writeStartDocument();
        this.writeName("$regex");
        this.write("/");
        this.write(regularExpression.getPattern());
        this.write("/");
        if (StringUtils.hasText((String)regularExpression.getOptions())) {
            this.writeName("$options");
            this.writeString(regularExpression.getOptions());
        }
        this.writeEndDocument();
    }

    public void writeRegularExpression(String name, BsonRegularExpression regularExpression) {
        this.writeName(name);
        this.writeRegularExpression(regularExpression);
    }

    public void writeStartArray() {
        this.preWriteValue();
        this.write("[");
        this.context = this.context.nestedArray();
    }

    public void writeStartArray(String name) {
        this.writeName(name);
        this.writeStartArray();
    }

    public void writeStartDocument() {
        this.preWriteValue();
        this.write("{");
        this.context = this.context.nestedDocument();
        this.state = State.NAME;
    }

    public void writeStartDocument(String name) {
        this.writeName(name);
        this.writeStartDocument();
    }

    public void writeString(String value) {
        this.write("'");
        this.write(value);
        this.write("'");
    }

    public void writeString(String name, String value) {
        this.writeName(name);
        this.writeString(value);
    }

    public void writeSymbol(String value) {
        this.writeStartDocument();
        this.writeName("$symbol");
        this.writeString(value);
        this.writeEndDocument();
    }

    public void writeSymbol(String name, String value) {
        this.writeName(name);
        this.writeSymbol(value);
    }

    public void writeTimestamp(BsonTimestamp value) {
        this.preWriteValue();
        this.writeStartDocument();
        this.writeName("$timestamp");
        this.writeStartDocument();
        this.writeName("t");
        this.buffer.append(value.getTime());
        this.writeName("i");
        this.buffer.append(value.getInc());
        this.writeEndDocument();
        this.writeEndDocument();
    }

    public void writeTimestamp(String name, BsonTimestamp value) {
        this.writeName(name);
        this.writeTimestamp(value);
    }

    public void writeUndefined() {
        this.writeStartDocument();
        this.writeName("$undefined");
        this.writeBoolean(true);
        this.writeEndDocument();
    }

    public void writeUndefined(String name) {
        this.writeName(name);
        this.writeUndefined();
    }

    public void pipe(BsonReader reader) {
    }

    public void writePlaceholder(String placeholder) {
        this.write(placeholder);
    }

    private void write(String str) {
        this.buffer.append(str);
    }

    private void preWriteValue() {
        if (this.context.contextType == JsonContextType.ARRAY && this.context.hasElements) {
            this.write(",");
        }
        this.context.hasElements = true;
    }

    private void setNextState() {
        this.state = this.context.contextType == JsonContextType.ARRAY ? State.VALUE : State.NAME;
    }

    private static class JsonContext {
        private final JsonContext parentContext;
        private final JsonContextType contextType;
        private boolean hasElements;

        JsonContext(JsonContext parentContext, JsonContextType contextType) {
            this.parentContext = parentContext;
            this.contextType = contextType;
        }

        JsonContext nestedDocument() {
            return new JsonContext(this, JsonContextType.DOCUMENT);
        }

        JsonContext nestedArray() {
            return new JsonContext(this, JsonContextType.ARRAY);
        }
    }

    private static enum JsonContextType {
        TOP_LEVEL,
        DOCUMENT,
        ARRAY;

    }

    private static enum State {
        INITIAL,
        NAME,
        VALUE,
        DONE;

    }
}

