/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import com.mongodb.DBRef;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ConvertingParameterAccessor
implements MongoParameterAccessor {
    private final MongoWriter<?> writer;
    private final MongoParameterAccessor delegate;

    public ConvertingParameterAccessor(MongoWriter<?> writer, MongoParameterAccessor delegate) {
        Assert.notNull(writer, (String)"MongoWriter must not be null");
        Assert.notNull((Object)delegate, (String)"MongoParameterAccessor must not be null");
        this.writer = writer;
        this.delegate = delegate;
    }

    public PotentiallyConvertingIterator iterator() {
        return new ConvertingIterator(this.delegate.iterator());
    }

    public @Nullable ScrollPosition getScrollPosition() {
        return this.delegate.getScrollPosition();
    }

    public Pageable getPageable() {
        return this.delegate.getPageable();
    }

    public Sort getSort() {
        return this.delegate.getSort();
    }

    public @Nullable Class<?> findDynamicProjection() {
        return this.delegate.findDynamicProjection();
    }

    public @Nullable Object getBindableValue(int index) {
        return this.getConvertedValue(this.delegate.getBindableValue(index), null);
    }

    @Override
    public @Nullable Range<Distance> getDistanceRange() {
        return this.delegate.getDistanceRange();
    }

    @Override
    public @Nullable Point getGeoNearLocation() {
        return this.delegate.getGeoNearLocation();
    }

    @Override
    public @Nullable TextCriteria getFullText() {
        return this.delegate.getFullText();
    }

    @Override
    public @Nullable Collation getCollation() {
        return this.delegate.getCollation();
    }

    @Override
    public @Nullable UpdateDefinition getUpdate() {
        return this.delegate.getUpdate();
    }

    public Limit getLimit() {
        return this.delegate.getLimit();
    }

    private @Nullable Object getConvertedValue(@Nullable Object value, @Nullable TypeInformation<?> typeInformation) {
        return this.writer.convertToMongoType(value, typeInformation == null ? null : typeInformation.getActualType());
    }

    public boolean hasBindableNullValue() {
        return this.delegate.hasBindableNullValue();
    }

    private static Collection<?> asCollection(@Nullable Object source) {
        if (source instanceof Iterable) {
            Iterable iterable = (Iterable)source;
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                return new ArrayList(collection);
            }
            ArrayList result = new ArrayList();
            for (Object element : iterable) {
                result.add(element);
            }
            return result;
        }
        if (source == null) {
            return Collections.emptySet();
        }
        return source.getClass().isArray() ? CollectionUtils.arrayToList((Object)source) : Collections.singleton(source);
    }

    @Override
    public Object @Nullable [] getValues() {
        return this.delegate.getValues();
    }

    private class ConvertingIterator
    implements PotentiallyConvertingIterator {
        private final Iterator<Object> delegate;

        public ConvertingIterator(Iterator<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public @Nullable Object next() {
            return this.delegate.next();
        }

        @Override
        public @Nullable Object nextConverted(MongoPersistentProperty property) {
            Object next = this.next();
            if (next == null) {
                return null;
            }
            if (property.isAssociation()) {
                if (next.getClass().isArray() || next instanceof Iterable) {
                    Collection<?> values = ConvertingParameterAccessor.asCollection(next);
                    ArrayList<DBRef> dbRefs = new ArrayList<DBRef>(values.size());
                    for (Object element : values) {
                        dbRefs.add(ConvertingParameterAccessor.this.writer.toDBRef(element, property));
                    }
                    return dbRefs;
                }
                return ConvertingParameterAccessor.this.writer.toDBRef(next, property);
            }
            return ConvertingParameterAccessor.this.getConvertedValue(next, property.getTypeInformation());
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }
    }

    public static interface PotentiallyConvertingIterator
    extends Iterator<Object> {
        public @Nullable Object nextConverted(MongoPersistentProperty var1);
    }
}

