/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class SimpleMessage<S, T>
implements Message<S, T> {
    private final @Nullable S raw;
    private final @Nullable T body;
    private final Message.MessageProperties properties;

    SimpleMessage(@Nullable S raw, @Nullable T body, Message.MessageProperties properties) {
        Assert.notNull((Object)properties, (String)"Properties must not be null Use MessageProperties.empty() instead");
        this.raw = raw;
        this.body = body;
        this.properties = properties;
    }

    @Override
    public @Nullable S getRaw() {
        return this.raw;
    }

    @Override
    public @Nullable T getBody() {
        return this.body;
    }

    @Override
    public Message.MessageProperties getProperties() {
        return this.properties;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleMessage that = (SimpleMessage)o;
        if (!ObjectUtils.nullSafeEquals(this.raw, that.raw)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.body, that.body)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.properties, (Object)that.properties);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.raw);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.body);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.properties);
        return result;
    }

    public String toString() {
        return "SimpleMessage(raw=" + this.getRaw() + ", body=" + this.getBody() + ", properties=" + this.getProperties() + ")";
    }
}

