/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class EncryptionOptions {
    private final String algorithm;
    private final EncryptionKey key;
    private final @Nullable QueryableEncryptionOptions queryableEncryptionOptions;

    public EncryptionOptions(String algorithm, EncryptionKey key) {
        this(algorithm, key, null);
    }

    public EncryptionOptions(String algorithm, EncryptionKey key, @Nullable QueryableEncryptionOptions queryableEncryptionOptions) {
        Assert.hasText((String)algorithm, (String)"Algorithm must not be empty");
        Assert.notNull((Object)key, (String)"EncryptionKey must not be empty");
        Assert.notNull((Object)key, (String)"QueryableEncryptionOptions must not be empty");
        this.key = key;
        this.algorithm = algorithm;
        this.queryableEncryptionOptions = queryableEncryptionOptions;
    }

    public EncryptionKey key() {
        return this.key;
    }

    public String algorithm() {
        return this.algorithm;
    }

    public @Nullable QueryableEncryptionOptions queryableEncryptionOptions() {
        return this.queryableEncryptionOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionOptions that = (EncryptionOptions)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.algorithm, (Object)that.algorithm)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.key, (Object)that.key)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.queryableEncryptionOptions, (Object)that.queryableEncryptionOptions);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.algorithm);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.key);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.queryableEncryptionOptions);
        return result;
    }

    public String toString() {
        return "EncryptionOptions{algorithm='" + this.algorithm + "', key=" + this.key + ", queryableEncryptionOptions='" + this.queryableEncryptionOptions + "'}";
    }

    public static class QueryableEncryptionOptions {
        private static final QueryableEncryptionOptions NONE = new QueryableEncryptionOptions(null, null, Map.of());
        private final @Nullable String queryType;
        private final @Nullable Long contentionFactor;
        private final Map<String, Object> attributes;

        private QueryableEncryptionOptions(@Nullable String queryType, @Nullable Long contentionFactor, Map<String, Object> attributes) {
            this.queryType = queryType;
            this.contentionFactor = contentionFactor;
            this.attributes = attributes;
        }

        public static QueryableEncryptionOptions none() {
            return NONE;
        }

        public QueryableEncryptionOptions queryType(@Nullable String queryType) {
            return new QueryableEncryptionOptions(queryType, this.contentionFactor, this.attributes);
        }

        public QueryableEncryptionOptions contentionFactor(@Nullable Long contentionFactor) {
            return new QueryableEncryptionOptions(this.queryType, contentionFactor, this.attributes);
        }

        public QueryableEncryptionOptions attributes(Map<String, Object> attributes) {
            return new QueryableEncryptionOptions(this.queryType, this.contentionFactor, attributes);
        }

        public @Nullable String getQueryType() {
            return this.queryType;
        }

        public @Nullable Long getContentionFactor() {
            return this.contentionFactor;
        }

        public Map<String, Object> getAttributes() {
            return Map.copyOf(this.attributes);
        }

        boolean isEmpty() {
            return this.getQueryType() == null && this.getContentionFactor() == null && this.getAttributes().isEmpty();
        }

        public String toString() {
            return "QueryableEncryptionOptions{queryType='" + this.queryType + "', contentionFactor=" + this.contentionFactor + ", attributes=" + this.attributes + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryableEncryptionOptions that = (QueryableEncryptionOptions)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.queryType, (Object)that.queryType)) {
                return false;
            }
            if (!ObjectUtils.nullSafeEquals((Object)this.contentionFactor, (Object)that.contentionFactor)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals(this.attributes, that.attributes);
        }

        public int hashCode() {
            return Objects.hash(this.queryType, this.contentionFactor, this.attributes);
        }
    }
}

