/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.schema.TypeUnifyingMergeFunction;

class MergedJsonSchemaProperty
implements JsonSchemaProperty {
    private final Iterable<JsonSchemaProperty> properties;
    private final BiFunction<Map<String, Object>, Map<String, Object>, Document> mergeFunction;

    MergedJsonSchemaProperty(Iterable<JsonSchemaProperty> properties) {
        this(properties, (MongoJsonSchema.ConflictResolutionFunction.Path k, Object a, Object b) -> {
            throw new IllegalStateException(String.format("Error resolving conflict for '%s'; No conflict resolution function defined", k));
        });
    }

    MergedJsonSchemaProperty(Iterable<JsonSchemaProperty> properties, MongoJsonSchema.ConflictResolutionFunction conflictResolutionFunction) {
        this(properties, new TypeUnifyingMergeFunction(conflictResolutionFunction));
    }

    MergedJsonSchemaProperty(Iterable<JsonSchemaProperty> properties, BiFunction<Map<String, Object>, Map<String, Object>, Document> mergeFunction) {
        this.properties = properties;
        this.mergeFunction = mergeFunction;
    }

    @Override
    public Set<JsonSchemaObject.Type> getTypes() {
        return Collections.emptySet();
    }

    @Override
    public Document toDocument() {
        Document document = new Document();
        for (JsonSchemaProperty property : this.properties) {
            document = this.mergeFunction.apply((Map<String, Object>)document, (Map<String, Object>)property.toDocument());
        }
        return document;
    }

    @Override
    public String getIdentifier() {
        return this.properties.iterator().next().getIdentifier();
    }
}

