/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.WriteConcern;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.DeleteManyModel;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateManyModel;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.reactivestreams.client.MongoCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.mapping.callback.EntityCallback;
import org.springframework.data.mapping.callback.ReactiveEntityCallbacks;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.BulkOperationsSupport;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.ReactiveBulkOperations;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.convert.UpdateMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.mapping.event.ReactiveAfterSaveCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.data.mongodb.core.mapping.event.ReactiveBeforeSaveCallback;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultReactiveBulkOperations
extends BulkOperationsSupport
implements ReactiveBulkOperations {
    private final ReactiveMongoOperations mongoOperations;
    private final String collectionName;
    private final ReactiveBulkOperationContext bulkOperationContext;
    private final List<Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>> models = new ArrayList<Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>>();
    @Nullable
    private WriteConcern defaultWriteConcern;
    private BulkWriteOptions bulkOptions;

    DefaultReactiveBulkOperations(ReactiveMongoOperations mongoOperations, String collectionName, ReactiveBulkOperationContext bulkOperationContext) {
        super(collectionName);
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        Assert.hasText((String)collectionName, (String)"CollectionName must not be null nor empty");
        Assert.notNull((Object)bulkOperationContext, (String)"BulkOperationContext must not be null");
        this.mongoOperations = mongoOperations;
        this.collectionName = collectionName;
        this.bulkOperationContext = bulkOperationContext;
        this.bulkOptions = DefaultReactiveBulkOperations.getBulkWriteOptions(bulkOperationContext.bulkMode());
    }

    void setDefaultWriteConcern(@Nullable WriteConcern defaultWriteConcern) {
        this.defaultWriteConcern = defaultWriteConcern;
    }

    @Override
    public ReactiveBulkOperations insert(Object document) {
        Assert.notNull((Object)document, (String)"Document must not be null");
        this.models.add((Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>)Mono.just((Object)document).flatMap(it -> {
            this.maybeEmitEvent(new BeforeConvertEvent<Object>(it, this.collectionName));
            return this.maybeInvokeBeforeConvertCallback(it);
        }).map(it -> new BulkOperationsSupport.SourceAwareWriteModelHolder(it, (WriteModel<Document>)new InsertOneModel((Object)this.getMappedObject(it)))));
        return this;
    }

    @Override
    public ReactiveBulkOperations insert(List<? extends Object> documents) {
        Assert.notNull(documents, (String)"Documents must not be null");
        documents.forEach(this::insert);
        return this;
    }

    @Override
    public ReactiveBulkOperations updateOne(Query query, UpdateDefinition update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        this.update(query, update, false, false);
        return this;
    }

    @Override
    public ReactiveBulkOperations updateMulti(Query query, UpdateDefinition update) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        this.update(query, update, false, true);
        return this;
    }

    @Override
    public ReactiveBulkOperations upsert(Query query, UpdateDefinition update) {
        return this.update(query, update, true, true);
    }

    @Override
    public ReactiveBulkOperations remove(Query query) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        DeleteOptions deleteOptions = new DeleteOptions();
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((DeleteOptions)deleteOptions).collation(arg_0));
        this.models.add((Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>)Mono.just((Object)query).map(it -> new BulkOperationsSupport.SourceAwareWriteModelHolder(it, (WriteModel<Document>)new DeleteManyModel((Bson)it.getQueryObject(), deleteOptions))));
        return this;
    }

    @Override
    public ReactiveBulkOperations remove(List<Query> removes) {
        Assert.notNull(removes, (String)"Removals must not be null");
        for (Query query : removes) {
            this.remove(query);
        }
        return this;
    }

    @Override
    public ReactiveBulkOperations replaceOne(Query query, Object replacement, FindAndReplaceOptions options) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)replacement, (String)"Replacement must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        ReplaceOptions replaceOptions = new ReplaceOptions();
        replaceOptions.upsert(options.isUpsert());
        query.getCollation().map(Collation::toMongoCollation).ifPresent(arg_0 -> ((ReplaceOptions)replaceOptions).collation(arg_0));
        this.models.add((Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>)Mono.just((Object)replacement).flatMap(it -> {
            this.maybeEmitEvent(new BeforeConvertEvent<Object>(it, this.collectionName));
            return this.maybeInvokeBeforeConvertCallback(it);
        }).map(it -> new BulkOperationsSupport.SourceAwareWriteModelHolder(it, (WriteModel<Document>)new ReplaceOneModel(this.getMappedQuery((Bson)query.getQueryObject()), (Object)this.getMappedObject(it), replaceOptions))));
        return this;
    }

    @Override
    public Mono<BulkWriteResult> execute() {
        try {
            Mono mono = this.mongoOperations.execute(this.collectionName, this::bulkWriteTo).next();
            return mono;
        }
        finally {
            this.bulkOptions = DefaultReactiveBulkOperations.getBulkWriteOptions(this.bulkOperationContext.bulkMode());
        }
    }

    private Mono<BulkWriteResult> bulkWriteTo(MongoCollection<Document> collection) {
        if (this.defaultWriteConcern != null) {
            collection = collection.withWriteConcern(this.defaultWriteConcern);
        }
        Flux concat = Flux.concat(this.models).flatMapSequential(it -> {
            Document target;
            WriteModel<Document> patt7756$temp = it.model();
            if (patt7756$temp instanceof InsertOneModel) {
                InsertOneModel iom = (InsertOneModel)patt7756$temp;
                target = (Document)iom.getDocument();
                this.maybeEmitBeforeSaveEvent((BulkOperationsSupport.SourceAwareWriteModelHolder)it);
                return this.maybeInvokeBeforeSaveCallback(it.source(), target).map(afterCallback -> new BulkOperationsSupport.SourceAwareWriteModelHolder(afterCallback, this.mapWriteModel(afterCallback, (WriteModel<Document>)iom)));
            }
            WriteModel<Document> patt8073$temp = it.model();
            if (patt8073$temp instanceof ReplaceOneModel) {
                ReplaceOneModel rom = (ReplaceOneModel)patt8073$temp;
                target = (Document)rom.getReplacement();
                this.maybeEmitBeforeSaveEvent((BulkOperationsSupport.SourceAwareWriteModelHolder)it);
                return this.maybeInvokeBeforeSaveCallback(it.source(), target).map(afterCallback -> new BulkOperationsSupport.SourceAwareWriteModelHolder(afterCallback, this.mapWriteModel(afterCallback, (WriteModel<Document>)rom)));
            }
            return Mono.just((Object)new BulkOperationsSupport.SourceAwareWriteModelHolder(it.source(), this.mapWriteModel(it.source(), it.model())));
        });
        MongoCollection theCollection = collection;
        return concat.collectList().flatMap(it -> Mono.from((Publisher)theCollection.bulkWrite(it.stream().map(BulkOperationsSupport.SourceAwareWriteModelHolder::model).collect(Collectors.toList()), this.bulkOptions)).doOnSuccess(state -> it.forEach(this::maybeEmitAfterSaveEvent)).flatMap(state -> {
            List monos = it.stream().map(this::maybeInvokeAfterSaveCallback).collect(Collectors.toList());
            return Flux.concat(monos).then(Mono.just((Object)state));
        }));
    }

    private ReactiveBulkOperations update(Query query, UpdateDefinition update, boolean upsert, boolean multi) {
        Assert.notNull((Object)query, (String)"Query must not be null");
        Assert.notNull((Object)update, (String)"Update must not be null");
        UpdateOptions options = DefaultReactiveBulkOperations.computeUpdateOptions(query, update, upsert);
        this.models.add((Mono<BulkOperationsSupport.SourceAwareWriteModelHolder>)Mono.just((Object)update).map(it -> {
            if (multi) {
                return new BulkOperationsSupport.SourceAwareWriteModelHolder(update, (WriteModel<Document>)new UpdateManyModel((Bson)query.getQueryObject(), (Bson)it.getUpdateObject(), options));
            }
            return new BulkOperationsSupport.SourceAwareWriteModelHolder(update, (WriteModel<Document>)new UpdateOneModel((Bson)query.getQueryObject(), (Bson)it.getUpdateObject(), options));
        }));
        return this;
    }

    @Override
    protected void maybeEmitEvent(ApplicationEvent event) {
        this.bulkOperationContext.publishEvent(event);
    }

    @Override
    protected UpdateMapper updateMapper() {
        return this.bulkOperationContext.updateMapper();
    }

    @Override
    protected QueryMapper queryMapper() {
        return this.bulkOperationContext.queryMapper();
    }

    @Override
    protected Optional<? extends MongoPersistentEntity<?>> entity() {
        return this.bulkOperationContext.entity();
    }

    private Document getMappedObject(Object source) {
        if (source instanceof Document) {
            return (Document)source;
        }
        Document sink = new Document();
        this.mongoOperations.getConverter().write(source, sink);
        return sink;
    }

    private Mono<Object> maybeInvokeAfterSaveCallback(BulkOperationsSupport.SourceAwareWriteModelHolder holder) {
        if (holder.model() instanceof InsertOneModel) {
            Document target = (Document)((InsertOneModel)holder.model()).getDocument();
            return this.maybeInvokeAfterSaveCallback(holder.source(), target);
        }
        if (holder.model() instanceof ReplaceOneModel) {
            Document target = (Document)((ReplaceOneModel)holder.model()).getReplacement();
            return this.maybeInvokeAfterSaveCallback(holder.source(), target);
        }
        return Mono.just((Object)holder.source());
    }

    private Mono<Object> maybeInvokeBeforeConvertCallback(Object value) {
        return this.bulkOperationContext.callback(ReactiveBeforeConvertCallback.class, value, this.collectionName);
    }

    private Mono<Object> maybeInvokeBeforeSaveCallback(Object value, Document mappedDocument) {
        return this.bulkOperationContext.callback(ReactiveBeforeSaveCallback.class, value, mappedDocument, this.collectionName);
    }

    private Mono<Object> maybeInvokeAfterSaveCallback(Object value, Document mappedDocument) {
        return this.bulkOperationContext.callback(ReactiveAfterSaveCallback.class, value, mappedDocument, this.collectionName);
    }

    record ReactiveBulkOperationContext(BulkOperations.BulkMode bulkMode, Optional<? extends MongoPersistentEntity<?>> entity, QueryMapper queryMapper, UpdateMapper updateMapper, @Nullable ApplicationEventPublisher eventPublisher, @Nullable ReactiveEntityCallbacks entityCallbacks) {
        public boolean skipEntityCallbacks() {
            return this.entityCallbacks == null;
        }

        public boolean skipEventPublishing() {
            return this.eventPublisher == null;
        }

        public <T> Mono<T> callback(Class<? extends EntityCallback> callbackType, T entity, String collectionName) {
            if (this.skipEntityCallbacks()) {
                return Mono.just(entity);
            }
            return this.entityCallbacks.callback(callbackType, entity, new Object[]{collectionName});
        }

        public <T> Mono<T> callback(Class<? extends EntityCallback> callbackType, T entity, Document document, String collectionName) {
            if (this.skipEntityCallbacks()) {
                return Mono.just(entity);
            }
            return this.entityCallbacks.callback(callbackType, entity, new Object[]{document, collectionName});
        }

        public void publishEvent(ApplicationEvent event) {
            if (this.skipEventPublishing()) {
                return;
            }
            this.eventPublisher.publishEvent(event);
        }
    }
}

