/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.bson.Document;
import org.bson.json.JsonParseException;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mapping.IdentifierAccessor;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ConvertingPropertyAccessor;
import org.springframework.data.mongodb.core.MappedDocument;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;

class EntityOperations {
    private static final String ID_FIELD = "_id";
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context;

    EntityOperations(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
        this.context = context;
    }

    <T> Entity<T> forEntity(T entity) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return MappedEntity.of(entity, this.context);
    }

    <T> AdaptibleEntity<T> forEntity(T entity, ConversionService conversionService) {
        Assert.notNull(entity, (String)"Bean must not be null!");
        Assert.notNull((Object)conversionService, (String)"ConversionService must not be null!");
        if (entity instanceof String) {
            return new UnmappedEntity<Document>(EntityOperations.parse(entity.toString()));
        }
        if (entity instanceof Map) {
            return new SimpleMappedEntity<Map>((Map)entity);
        }
        return AdaptibleMappedEntity.of(entity, this.context, conversionService);
    }

    static boolean isCollectionLike(@Nullable Object source) {
        if (source == null) {
            return false;
        }
        return ObjectUtils.isArray((Object)source) || source instanceof Collection || source instanceof Iterator;
    }

    public String determineCollectionName(@Nullable Class<?> entityClass) {
        if (entityClass == null) {
            throw new InvalidDataAccessApiUsageException("No class parameter provided, entity collection can't be determined!");
        }
        return ((MongoPersistentEntity)this.context.getRequiredPersistentEntity(entityClass)).getCollection();
    }

    public Query getByIdInQuery(Collection<?> entities) {
        LinkedMultiValueMap byIds = new LinkedMultiValueMap();
        entities.stream().map(this::forEntity).forEach(arg_0 -> EntityOperations.lambda$getByIdInQuery$0((MultiValueMap)byIds, arg_0));
        Criteria[] criterias = (Criteria[])byIds.entrySet().stream().map(it -> Criteria.where((String)it.getKey()).in((Collection)it.getValue())).toArray(Criteria[]::new);
        return new Query(criterias.length == 1 ? criterias[0] : new Criteria().orOperator(criterias));
    }

    public String getIdPropertyName(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(type);
        if (persistentEntity != null && persistentEntity.getIdProperty() != null) {
            return ((MongoPersistentProperty)persistentEntity.getRequiredIdProperty()).getName();
        }
        return ID_FIELD;
    }

    public String nearQueryDistanceFieldName(Class<?> domainType) {
        MongoPersistentEntity persistentEntity = (MongoPersistentEntity)this.context.getPersistentEntity(domainType);
        if (persistentEntity == null || persistentEntity.getPersistentProperty("dis") == null) {
            return "dis";
        }
        String distanceFieldName = "calculated-distance";
        int counter = 0;
        while (persistentEntity.getPersistentProperty(distanceFieldName) != null) {
            distanceFieldName = distanceFieldName + "-" + counter++;
        }
        return distanceFieldName;
    }

    private static Document parse(String source) {
        try {
            return Document.parse((String)source);
        }
        catch (JsonParseException o_O) {
            throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)o_O);
        }
        catch (RuntimeException o_O) {
            if (ClassUtils.matchesTypeName(o_O.getClass(), (String)"JSONParseException")) {
                throw new MappingException("Could not parse given String to save into a JSON document!", (Throwable)o_O);
            }
            throw o_O;
        }
    }

    public <T> TypedOperations<T> forType(@Nullable Class<T> entityClass) {
        MongoPersistentEntity entity;
        if (entityClass != null && (entity = (MongoPersistentEntity)this.context.getPersistentEntity(entityClass)) != null) {
            return new TypedEntityOperations(entity);
        }
        return UntypedOperations.instance();
    }

    private static /* synthetic */ void lambda$getByIdInQuery$0(MultiValueMap byIds, Entity it) {
        byIds.add((Object)it.getIdFieldName(), it.getId());
    }

    static class TypedEntityOperations<T>
    implements TypedOperations<T> {
        private final MongoPersistentEntity<T> entity;

        protected TypedEntityOperations(MongoPersistentEntity<T> entity) {
            this.entity = entity;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.ofNullable(this.entity.getCollation());
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query.getCollation().isPresent()) {
                return query.getCollation();
            }
            return Optional.ofNullable(this.entity.getCollation());
        }
    }

    static enum UntypedOperations implements TypedOperations<Object>
    {
        INSTANCE;


        public static <T> TypedOperations<T> instance() {
            return INSTANCE;
        }

        @Override
        public Optional<Collation> getCollation() {
            return Optional.empty();
        }

        @Override
        public Optional<Collation> getCollation(Query query) {
            if (query == null) {
                return Optional.empty();
            }
            return query.getCollation();
        }
    }

    static interface TypedOperations<T> {
        public Optional<Collation> getCollation();

        public Optional<Collation> getCollation(Query var1);
    }

    private static class AdaptibleMappedEntity<T>
    extends MappedEntity<T>
    implements AdaptibleEntity<T> {
        private final MongoPersistentEntity<?> entity;
        private final ConvertingPropertyAccessor<T> propertyAccessor;
        private final IdentifierAccessor identifierAccessor;

        private AdaptibleMappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor identifierAccessor, ConvertingPropertyAccessor<T> propertyAccessor) {
            super(entity, identifierAccessor, propertyAccessor);
            this.entity = entity;
            this.propertyAccessor = propertyAccessor;
            this.identifierAccessor = identifierAccessor;
        }

        private static <T> AdaptibleEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context, ConversionService conversionService) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new AdaptibleMappedEntity<T>(entity, identifierAccessor, new ConvertingPropertyAccessor(propertyAccessor, conversionService));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            if (id == null) {
                return (T)this.propertyAccessor.getBean();
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getIdProperty();
            if (idProperty == null) {
                return (T)this.propertyAccessor.getBean();
            }
            if (this.identifierAccessor.getIdentifier() != null) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)idProperty, id);
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        @Nullable
        public Number getVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return (Number)this.propertyAccessor.getProperty((PersistentProperty)versionProperty, Number.class);
        }

        @Override
        public T initializeVersionProperty() {
            MongoPersistentProperty versionProperty;
            if (!this.entity.hasVersionProperty()) {
                return (T)this.propertyAccessor.getBean();
            }
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)((versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty()).getType().isPrimitive() ? 1 : 0));
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public T incrementVersion() {
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            Number version = this.getVersion();
            Long nextVersion = version == null ? 0L : version.longValue() + 1L;
            this.propertyAccessor.setProperty((PersistentProperty)versionProperty, (Object)nextVersion);
            return (T)this.propertyAccessor.getBean();
        }
    }

    private static class MappedEntity<T>
    implements Entity<T> {
        private final MongoPersistentEntity<?> entity;
        private final IdentifierAccessor idAccessor;
        private final PersistentPropertyAccessor<T> propertyAccessor;

        protected MappedEntity(MongoPersistentEntity<?> entity, IdentifierAccessor idAccessor, PersistentPropertyAccessor<T> propertyAccessor) {
            this.entity = entity;
            this.idAccessor = idAccessor;
            this.propertyAccessor = propertyAccessor;
        }

        private static <T> MappedEntity<T> of(T bean, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> context) {
            MongoPersistentEntity entity = (MongoPersistentEntity)context.getRequiredPersistentEntity(bean.getClass());
            IdentifierAccessor identifierAccessor = entity.getIdentifierAccessor(bean);
            PersistentPropertyAccessor propertyAccessor = entity.getPropertyAccessor(bean);
            return new MappedEntity<T>(entity, identifierAccessor, propertyAccessor);
        }

        @Override
        public String getIdFieldName() {
            return ((MongoPersistentProperty)this.entity.getRequiredIdProperty()).getFieldName();
        }

        @Override
        public Object getId() {
            return this.idAccessor.getRequiredIdentifier();
        }

        @Override
        public Query getByIdQuery() {
            if (!this.entity.hasIdProperty()) {
                throw new MappingException("No id property found for object of type " + this.entity.getType() + "!");
            }
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            return Query.query(Criteria.where(idProperty.getName()).is(this.getId()));
        }

        @Override
        public Query getQueryForVersion() {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            MongoPersistentProperty versionProperty = (MongoPersistentProperty)this.entity.getRequiredVersionProperty();
            return new Query(Criteria.where(idProperty.getName()).is(this.getId()).and(versionProperty.getName()).is(this.getVersion()));
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean = this.propertyAccessor.getBean();
            Document document = new Document();
            writer.write(bean, document);
            if (document.containsKey((Object)EntityOperations.ID_FIELD) && document.get((Object)EntityOperations.ID_FIELD) == null) {
                document.remove((Object)EntityOperations.ID_FIELD);
            }
            return MappedDocument.of(document);
        }

        @Override
        public void assertUpdateableIdIfNotSet() {
            if (!this.entity.hasIdProperty()) {
                return;
            }
            MongoPersistentProperty property = (MongoPersistentProperty)this.entity.getRequiredIdProperty();
            Object propertyValue = this.idAccessor.getIdentifier();
            if (propertyValue != null) {
                return;
            }
            if (!MongoSimpleTypes.AUTOGENERATED_ID_TYPES.contains(property.getType())) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot autogenerate id of type %s for entity of type %s!", property.getType().getName(), this.entity.getType().getName()));
            }
        }

        @Override
        public boolean isVersionedEntity() {
            return this.entity.hasVersionProperty();
        }

        @Override
        @Nullable
        public Object getVersion() {
            return this.propertyAccessor.getProperty(this.entity.getRequiredVersionProperty());
        }

        @Override
        public T getBean() {
            return (T)this.propertyAccessor.getBean();
        }

        @Override
        public boolean isNew() {
            return this.entity.isNew(this.propertyAccessor.getBean());
        }
    }

    private static class SimpleMappedEntity<T extends Map<String, Object>>
    extends UnmappedEntity<T> {
        protected SimpleMappedEntity(T map) {
            super(map);
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            Object bean = this.getBean();
            bean = bean instanceof Document ? (Document)bean : new Document((Map)bean);
            Document document = new Document();
            writer.write(bean, document);
            return MappedDocument.of(document);
        }
    }

    private static class UnmappedEntity<T extends Map<String, Object>>
    implements AdaptibleEntity<T> {
        private final T map;

        protected UnmappedEntity(T map) {
            this.map = map;
        }

        @Override
        public String getIdFieldName() {
            return EntityOperations.ID_FIELD;
        }

        @Override
        public Object getId() {
            return this.map.get(EntityOperations.ID_FIELD);
        }

        @Override
        public Query getByIdQuery() {
            return Query.query(Criteria.where(EntityOperations.ID_FIELD).is(this.map.get(EntityOperations.ID_FIELD)));
        }

        @Override
        @Nullable
        public T populateIdIfNecessary(@Nullable Object id) {
            this.map.put((String)EntityOperations.ID_FIELD, (Object)id);
            return this.map;
        }

        @Override
        public Query getQueryForVersion() {
            throw new MappingException("Cannot query for version on plain Documents!");
        }

        @Override
        public MappedDocument toMappedDocument(MongoWriter<? super T> writer) {
            return MappedDocument.of(this.map instanceof Document ? (Document)this.map : new Document(this.map));
        }

        @Override
        public T initializeVersionProperty() {
            return this.map;
        }

        @Override
        @Nullable
        public Number getVersion() {
            return null;
        }

        @Override
        public T incrementVersion() {
            return this.map;
        }

        @Override
        public T getBean() {
            return this.map;
        }

        @Override
        public boolean isNew() {
            return this.map.get(EntityOperations.ID_FIELD) != null;
        }
    }

    static interface AdaptibleEntity<T>
    extends Entity<T> {
        @Nullable
        public T populateIdIfNecessary(@Nullable Object var1);

        public T initializeVersionProperty();

        public T incrementVersion();

        @Override
        @Nullable
        public Number getVersion();
    }

    static interface Entity<T> {
        public String getIdFieldName();

        public Object getId();

        public Query getByIdQuery();

        default public Query getRemoveByQuery() {
            return this.isVersionedEntity() ? this.getQueryForVersion() : this.getByIdQuery();
        }

        public Query getQueryForVersion();

        public MappedDocument toMappedDocument(MongoWriter<? super T> var1);

        default public void assertUpdateableIdIfNotSet() {
        }

        default public boolean isVersionedEntity() {
            return false;
        }

        @Nullable
        public Object getVersion();

        public T getBean();

        public boolean isNew();
    }
}

