/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bson.AbstractBsonReader;
import org.bson.BsonBinarySubType;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.Transformer;
import org.bson.assertions.Assertions;
import org.bson.codecs.BsonTypeClassMap;
import org.bson.codecs.BsonTypeCodecMap;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.Codec;
import org.bson.codecs.CollectibleCodec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.Encoder;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.IdGenerator;
import org.bson.codecs.ObjectIdGenerator;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonParseException;
import org.springframework.data.mongodb.util.json.DateTimeFormatter;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingJsonReader;
import org.springframework.data.spel.EvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class ParameterBindingDocumentCodec
implements CollectibleCodec<Document> {
    private static final String ID_FIELD_NAME = "_id";
    private static final CodecRegistry DEFAULT_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new BsonValueCodecProvider(), new DocumentCodecProvider()));
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap();
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final IdGenerator idGenerator;
    private final Transformer valueTransformer;

    public ParameterBindingDocumentCodec() {
        this(DEFAULT_REGISTRY);
    }

    public ParameterBindingDocumentCodec(CodecRegistry registry) {
        this(registry, DEFAULT_BSON_TYPE_CLASS_MAP);
    }

    public ParameterBindingDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap) {
        this(registry, bsonTypeClassMap, null);
    }

    public ParameterBindingDocumentCodec(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer) {
        this.registry = (CodecRegistry)Assertions.notNull((String)"registry", (Object)registry);
        this.bsonTypeCodecMap = new BsonTypeCodecMap((BsonTypeClassMap)Assertions.notNull((String)"bsonTypeClassMap", (Object)bsonTypeClassMap), registry);
        this.idGenerator = new ObjectIdGenerator();
        this.valueTransformer = valueTransformer != null ? valueTransformer : new Transformer(){

            public Object transform(Object value) {
                return value;
            }
        };
    }

    public boolean documentHasId(Document document) {
        return document.containsKey((Object)ID_FIELD_NAME);
    }

    public BsonValue getDocumentId(Document document) {
        if (!this.documentHasId(document)) {
            throw new IllegalStateException("The document does not contain an _id");
        }
        Object id = document.get((Object)ID_FIELD_NAME);
        if (id instanceof BsonValue) {
            return (BsonValue)id;
        }
        BsonDocument idHoldingDocument = new BsonDocument();
        BsonDocumentWriter writer = new BsonDocumentWriter(idHoldingDocument);
        writer.writeStartDocument();
        writer.writeName(ID_FIELD_NAME);
        this.writeValue((BsonWriter)writer, EncoderContext.builder().build(), id);
        writer.writeEndDocument();
        return idHoldingDocument.get((Object)ID_FIELD_NAME);
    }

    public Document generateIdIfAbsentFromDocument(Document document) {
        if (!this.documentHasId(document)) {
            document.put(ID_FIELD_NAME, this.idGenerator.generate());
        }
        return document;
    }

    public void encode(BsonWriter writer, Document document, EncoderContext encoderContext) {
        this.writeMap(writer, (Map<String, Object>)document, encoderContext);
    }

    public Document decode(@Nullable String json, Object[] values) {
        return this.decode(json, new ParameterBindingContext(index -> values[index], new SpelExpressionParser(), () -> EvaluationContextProvider.DEFAULT.getEvaluationContext((Object)values)));
    }

    public Document decode(@Nullable String json, ParameterBindingContext bindingContext) {
        if (StringUtils.isEmpty((Object)json)) {
            return new Document();
        }
        ParameterBindingJsonReader reader = new ParameterBindingJsonReader(json, bindingContext);
        return this.decode((BsonReader)reader, DecoderContext.builder().build());
    }

    public Document decode(BsonReader reader, DecoderContext decoderContext) {
        if (reader instanceof ParameterBindingJsonReader) {
            ParameterBindingJsonReader bindingReader = (ParameterBindingJsonReader)reader;
            if (bindingReader.currentValue instanceof Document) {
                return (Document)bindingReader.currentValue;
            }
        }
        Document document = new Document();
        reader.readStartDocument();
        try {
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String fieldName = reader.readName();
                Object value = this.readValue(reader, decoderContext);
                document.put(fieldName, value);
            }
        }
        catch (JsonParseException e) {
            try {
                Object value = this.readValue(reader, decoderContext);
                if (value instanceof Map && !((Map)value).isEmpty()) {
                    return new Document((Map)value);
                }
            }
            catch (Exception ex) {
                e.addSuppressed((Throwable)ex);
                throw e;
            }
        }
        reader.readEndDocument();
        return document;
    }

    public Class<Document> getEncoderClass() {
        return Document.class;
    }

    private void beforeFields(BsonWriter bsonWriter, EncoderContext encoderContext, Map<String, Object> document) {
        if (encoderContext.isEncodingCollectibleDocument() && document.containsKey(ID_FIELD_NAME)) {
            bsonWriter.writeName(ID_FIELD_NAME);
            this.writeValue(bsonWriter, encoderContext, document.get(ID_FIELD_NAME));
        }
    }

    private boolean skipField(EncoderContext encoderContext, String key) {
        return encoderContext.isEncodingCollectibleDocument() && key.equals(ID_FIELD_NAME);
    }

    private void writeValue(BsonWriter writer, EncoderContext encoderContext, Object value) {
        if (value == null) {
            writer.writeNull();
        } else if (value instanceof Iterable) {
            this.writeIterable(writer, (Iterable)value, encoderContext.getChildContext());
        } else if (value instanceof Map) {
            this.writeMap(writer, (Map)value, encoderContext.getChildContext());
        } else {
            Codec codec = this.registry.get(value.getClass());
            encoderContext.encodeWithChildContext((Encoder)codec, writer, value);
        }
    }

    private void writeMap(BsonWriter writer, Map<String, Object> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        this.beforeFields(writer, encoderContext, map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (this.skipField(encoderContext, entry.getKey())) continue;
            writer.writeName(entry.getKey());
            this.writeValue(writer, encoderContext, entry.getValue());
        }
        writer.writeEndDocument();
    }

    private void writeIterable(BsonWriter writer, Iterable<Object> list, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Object value : list) {
            this.writeValue(writer, encoderContext, value);
        }
        writer.writeEndArray();
    }

    private Object readValue(BsonReader reader, DecoderContext decoderContext) {
        BsonType bsonType;
        if (reader instanceof ParameterBindingJsonReader) {
            ParameterBindingJsonReader bindingReader = (ParameterBindingJsonReader)reader;
            if (bindingReader.currentValue != null) {
                Object value = bindingReader.currentValue;
                if (ObjectUtils.nullSafeEquals((Object)BsonType.DATE_TIME, (Object)bindingReader.getCurrentBsonType()) && !(value instanceof Date)) {
                    if (value instanceof Number) {
                        value = new Date((Long)NumberUtils.convertNumberToTargetClass((Number)((Number)value), Long.class));
                    } else if (value instanceof String) {
                        value = new Date(DateTimeFormatter.parse((String)value));
                    }
                }
                bindingReader.setState(AbstractBsonReader.State.TYPE);
                bindingReader.currentValue = null;
                return value;
            }
        }
        if ((bsonType = reader.getCurrentBsonType()) == BsonType.NULL) {
            reader.readNull();
            return null;
        }
        if (bsonType == BsonType.ARRAY) {
            return this.readList(reader, decoderContext);
        }
        if (bsonType == BsonType.BINARY && BsonBinarySubType.isUuid((byte)reader.peekBinarySubType()) && reader.peekBinarySize() == 16) {
            return this.registry.get(UUID.class).decode(reader, decoderContext);
        }
        Object codecToUse = this.bsonTypeCodecMap.get(bsonType);
        if (codecToUse instanceof DocumentCodec) {
            codecToUse = this;
        }
        return this.valueTransformer.transform(codecToUse.decode(reader, decoderContext));
    }

    private List<Object> readList(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }
}

