/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.client.MongoClient;
import java.util.Date;
import org.bson.Document;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Background Flushing Metrics")
public class BackgroundFlushingMetrics
extends AbstractMonitor {
    @Deprecated
    public BackgroundFlushingMetrics(com.mongodb.MongoClient mongoClient) {
        super(mongoClient);
    }

    public BackgroundFlushingMetrics(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Flushes")
    public int getFlushes() {
        return this.getFlushingData("flushes", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Total ms", unit="ms")
    public int getTotalMs() {
        return this.getFlushingData("total_ms", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Average ms", unit="ms")
    public double getAverageMs() {
        return this.getFlushingData("average_ms", Double.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Last Ms", unit="ms")
    public int getLastMs() {
        return this.getFlushingData("last_ms", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Last finished")
    public Date getLastFinished() {
        return this.getLast();
    }

    private <T> T getFlushingData(String key, Class<T> targetClass) {
        Document mem = (Document)this.getServerStatus().get((Object)"backgroundFlushing");
        return (T)mem.get((Object)key);
    }

    private Date getLast() {
        Document bgFlush = (Document)this.getServerStatus().get((Object)"backgroundFlushing");
        Date lastFinished = (Date)bgFlush.get((Object)"last_finished");
        return lastFinished;
    }
}

