/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.IntFunction;
import org.reactivestreams.Publisher;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ReactiveGridFsResource
extends AbstractResource {
    private static final Integer DEFAULT_CHUNK_SIZE = 262144;
    @Nullable
    private final GridFSFile file;
    private final String filename;
    private final IntFunction<Flux<DataBuffer>> contentFunction;

    private ReactiveGridFsResource(String filename, Publisher<DataBuffer> content) {
        this.file = null;
        this.filename = filename;
        this.contentFunction = any -> Flux.from((Publisher)content);
    }

    public ReactiveGridFsResource(GridFSFile file, Publisher<DataBuffer> content) {
        this(file, (int any) -> Flux.from((Publisher)content));
    }

    ReactiveGridFsResource(GridFSFile file, IntFunction<Flux<DataBuffer>> contentFunction) {
        this.file = file;
        this.filename = file.getFilename();
        this.contentFunction = contentFunction;
    }

    public static ReactiveGridFsResource absent(String filename) {
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        return new ReactiveGridFsResource(filename, (Publisher<DataBuffer>)Flux.empty());
    }

    public InputStream getInputStream() throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public long contentLength() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getLength();
    }

    public String getFilename() throws IllegalStateException {
        return this.filename;
    }

    public boolean exists() {
        return this.file != null;
    }

    public long lastModified() throws IOException {
        this.verifyExists();
        return this.getGridFSFile().getUploadDate().getTime();
    }

    public String getDescription() {
        return String.format("GridFs resource [%s]", this.getFilename());
    }

    public Object getId() {
        Assert.state((boolean)this.exists(), () -> String.format("%s does not exist.", this.getDescription()));
        return this.getGridFSFile().getId();
    }

    @Nullable
    public GridFSFile getGridFSFile() {
        return this.file;
    }

    public Flux<DataBuffer> getDownloadStream() {
        return this.getDownloadStream(DEFAULT_CHUNK_SIZE);
    }

    public Flux<DataBuffer> getDownloadStream(int chunkSize) {
        if (!this.exists()) {
            return Flux.error((Throwable)new FileNotFoundException(String.format("%s does not exist.", this.getDescription())));
        }
        return this.contentFunction.apply(chunkSize);
    }

    private void verifyExists() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist.", this.getDescription()));
        }
    }
}

