/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.repository.query.ReactivePartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.ReactiveStringBasedAggregation;
import org.springframework.data.mongodb.repository.query.ReactiveStringBasedMongoQuery;
import org.springframework.data.mongodb.repository.support.MappingMongoEntityInformation;
import org.springframework.data.mongodb.repository.support.ReactiveQuerydslMongoPredicateExecutor;
import org.springframework.data.mongodb.repository.support.SimpleReactiveMongoRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.ReactiveQuerydslPredicateExecutor;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ReactiveMongoRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final ReactiveMongoOperations operations;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

    public ReactiveMongoRepositoryFactory(ReactiveMongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"ReactiveMongoOperations must not be null!");
        this.operations = mongoOperations;
        this.mappingContext = mongoOperations.getConverter().getMappingContext();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleReactiveMongoRepository.class;
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        boolean isQueryDslRepository;
        RepositoryComposition.RepositoryFragments fragments = RepositoryComposition.RepositoryFragments.empty();
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && ReactiveQuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            MongoEntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType(), metadata);
            fragments = fragments.append(RepositoryFragment.implemented((Object)this.getTargetRepositoryViaReflection(ReactiveQuerydslMongoPredicateExecutor.class, new Object[]{entityInformation, this.operations})));
        }
        return fragments;
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        MongoEntityInformation entityInformation = this.getEntityInformation(information.getDomainType(), (RepositoryMetadata)information);
        return this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new MongoQueryLookupStrategy(this.operations, evaluationContextProvider, this.mappingContext));
    }

    public <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return this.getEntityInformation(domainClass, null);
    }

    private <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass, @Nullable RepositoryMetadata metadata) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingMongoEntityInformation(entity, metadata != null ? metadata.getIdType() : null);
    }

    private static class MongoQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ReactiveMongoOperations operations;
        private final QueryMethodEvaluationContextProvider evaluationContextProvider;
        private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            ReactiveMongoQueryMethod queryMethod = new ReactiveMongoQueryMethod(method, metadata, factory, this.mappingContext);
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new ReactiveStringBasedMongoQuery(namedQuery, queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedAggregation()) {
                return new ReactiveStringBasedAggregation(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new ReactiveStringBasedMongoQuery(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
            }
            return new ReactivePartTreeMongoQuery(queryMethod, this.operations, EXPRESSION_PARSER, this.evaluationContextProvider);
        }

        MongoQueryLookupStrategy(ReactiveMongoOperations operations, QueryMethodEvaluationContextProvider evaluationContextProvider, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            this.operations = operations;
            this.evaluationContextProvider = evaluationContextProvider;
            this.mappingContext = mappingContext;
        }
    }
}

