/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.query.AbstractReactiveMongoQuery;
import org.springframework.data.mongodb.repository.query.BooleanUtil;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.ExpressionEvaluatingParameterBinder;
import org.springframework.data.mongodb.repository.query.ReactiveMongoQueryMethod;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class ReactiveStringBasedMongoQuery
extends AbstractReactiveMongoQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time!";
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveStringBasedMongoQuery.class);
    private static final StringBasedMongoQuery.ParameterBindingParser BINDING_PARSER = StringBasedMongoQuery.ParameterBindingParser.INSTANCE;
    private final String query;
    private final String fieldSpec;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final boolean isDeleteQuery;
    private final List<StringBasedMongoQuery.ParameterBinding> queryParameterBindings;
    private final List<StringBasedMongoQuery.ParameterBinding> fieldSpecParameterBindings;
    private final ExpressionEvaluatingParameterBinder parameterBinder;

    public ReactiveStringBasedMongoQuery(ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, mongoOperations, expressionParser, evaluationContextProvider);
    }

    public ReactiveStringBasedMongoQuery(String query, ReactiveMongoQueryMethod method, ReactiveMongoOperations mongoOperations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations);
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        this.queryParameterBindings = new ArrayList<StringBasedMongoQuery.ParameterBinding>();
        this.query = BINDING_PARSER.parseAndCollectParameterBindingsFromQueryIntoBindings(query, this.queryParameterBindings);
        this.fieldSpecParameterBindings = new ArrayList<StringBasedMongoQuery.ParameterBinding>();
        this.fieldSpec = BINDING_PARSER.parseAndCollectParameterBindingsFromQueryIntoBindings(method.getFieldSpecification(), this.fieldSpecParameterBindings);
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            this.isDeleteQuery = queryAnnotation.delete();
            if (ReactiveStringBasedMongoQuery.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery, this.isDeleteQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, new Object[]{method}));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
            this.isDeleteQuery = false;
        }
        this.parameterBinder = new ExpressionEvaluatingParameterBinder(expressionParser, evaluationContextProvider);
    }

    @Override
    protected org.springframework.data.mongodb.core.query.Query createQuery(ConvertingParameterAccessor accessor) {
        String queryString = this.parameterBinder.bind(this.query, accessor, new ExpressionEvaluatingParameterBinder.BindingContext(this.getQueryMethod().getParameters(), this.queryParameterBindings));
        String fieldsString = this.parameterBinder.bind(this.fieldSpec, accessor, new ExpressionEvaluatingParameterBinder.BindingContext(this.getQueryMethod().getParameters(), this.fieldSpecParameterBindings));
        org.springframework.data.mongodb.core.query.Query query = new BasicQuery(queryString, fieldsString).with(accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created query %s for %s fields.", query.getQueryObject(), query.getFieldsObject()));
        }
        return query;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    private static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return BooleanUtil.countBooleanTrueValues(isCountQuery, isExistsQuery, isDeleteQuery) > 1;
    }
}

