/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.data.mongodb.core.ExecutableFindOperation;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoOperations operations;
    private final ExecutableFindOperation.FindWithProjection<?> findOperationWithProjection;

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations operations) {
        Assert.notNull((Object)operations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null!");
        this.method = method;
        this.operations = operations;
        ReturnedType returnedType = method.getResultProcessor().getReturnedType();
        this.findOperationWithProjection = operations.query(returnedType.getDomainType()).inCollection(method.getEntityInformation().getCollectionName());
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        ConvertingParameterAccessor accessor = new ConvertingParameterAccessor(this.operations.getConverter(), new MongoParametersParameterAccessor(this.method, parameters));
        Query query = this.createQuery(accessor);
        this.applyQueryMetaAttributesWhenPresent(query);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        Class typeToRead = processor.getReturnedType().getTypeToRead();
        ExecutableFindOperation.FindWithProjection<?> find = typeToRead == null ? this.findOperationWithProjection : this.findOperationWithProjection.as(typeToRead);
        MongoQueryExecution execution = this.getExecution(accessor, find);
        return processor.processResult(execution.execute(query));
    }

    private MongoQueryExecution getExecution(ConvertingParameterAccessor accessor, ExecutableFindOperation.FindWithQuery<?> operation) {
        if (this.isDeleteQuery()) {
            return new MongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery() && this.method.isPageQuery()) {
            return new MongoQueryExecution.PagingGeoNearExecution(operation, this.method, accessor, this);
        }
        if (this.method.isGeoNearQuery()) {
            return new MongoQueryExecution.GeoNearExecution(operation, this.method, accessor);
        }
        if (this.method.isSliceQuery()) {
            return new MongoQueryExecution.SlicedExecution(operation, accessor.getPageable());
        }
        if (this.method.isStreamQuery()) {
            return q -> operation.matching(q).stream();
        }
        if (this.method.isCollectionQuery()) {
            return q -> operation.matching(q.with(accessor.getPageable())).all();
        }
        if (this.method.isPageQuery()) {
            return new MongoQueryExecution.PagedExecution(operation, accessor.getPageable());
        }
        if (this.isCountQuery()) {
            return q -> operation.matching(q).count();
        }
        if (this.isExistsQuery()) {
            return q -> operation.matching(q).exists();
        }
        return q -> operation.matching(q).oneValue();
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isExistsQuery();

    protected abstract boolean isDeleteQuery();
}

