/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOptions;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.FieldsExposingAggregationOperation;
import org.springframework.data.mongodb.core.aggregation.GeoNearOperation;
import org.springframework.data.mongodb.core.aggregation.GroupOperation;
import org.springframework.data.mongodb.core.aggregation.InheritingExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.LimitOperation;
import org.springframework.data.mongodb.core.aggregation.LookupOperation;
import org.springframework.data.mongodb.core.aggregation.MatchOperation;
import org.springframework.data.mongodb.core.aggregation.ProjectionOperation;
import org.springframework.data.mongodb.core.aggregation.SkipOperation;
import org.springframework.data.mongodb.core.aggregation.SortOperation;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.aggregation.UnwindOperation;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.util.Assert;

public class Aggregation {
    public static final String ROOT = SystemVariable.ROOT.toString();
    public static final String CURRENT = SystemVariable.CURRENT.toString();
    public static final AggregationOperationContext DEFAULT_CONTEXT = new NoOpAggregationOperationContext();
    public static final AggregationOptions DEFAULT_OPTIONS = Aggregation.newAggregationOptions().build();
    protected final List<AggregationOperation> operations;
    private final AggregationOptions options;

    public static Aggregation newAggregation(List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static Aggregation newAggregation(AggregationOperation ... operations) {
        return new Aggregation(operations);
    }

    public Aggregation withOptions(AggregationOptions options) {
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null.");
        return new Aggregation(this.operations, options);
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, List<? extends AggregationOperation> operations) {
        return Aggregation.newAggregation(type, operations.toArray(new AggregationOperation[operations.size()]));
    }

    public static <T> TypedAggregation<T> newAggregation(Class<T> type, AggregationOperation ... operations) {
        return new TypedAggregation<T>(type, operations);
    }

    protected Aggregation(AggregationOperation ... aggregationOperations) {
        this(Aggregation.asAggregationList(aggregationOperations));
    }

    protected static List<AggregationOperation> asAggregationList(AggregationOperation ... aggregationOperations) {
        Assert.notEmpty((Object[])aggregationOperations, (String)"AggregationOperations must not be null or empty!");
        return Arrays.asList(aggregationOperations);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations) {
        this(aggregationOperations, DEFAULT_OPTIONS);
    }

    protected Aggregation(List<AggregationOperation> aggregationOperations, AggregationOptions options) {
        Assert.notNull(aggregationOperations, (String)"AggregationOperations must not be null!");
        Assert.isTrue((!aggregationOperations.isEmpty() ? 1 : 0) != 0, (String)"At least one AggregationOperation has to be provided");
        Assert.notNull((Object)options, (String)"AggregationOptions must not be null!");
        this.operations = aggregationOperations;
        this.options = options;
    }

    public static String previousOperation() {
        return "_id";
    }

    public static ProjectionOperation project(String ... fields) {
        return Aggregation.project(Aggregation.fields(fields));
    }

    public static ProjectionOperation project(Fields fields) {
        return new ProjectionOperation(fields);
    }

    public static UnwindOperation unwind(String field) {
        return new UnwindOperation(Fields.field(field));
    }

    public static GroupOperation group(String ... fields) {
        return Aggregation.group(Aggregation.fields(fields));
    }

    public static GroupOperation group(Fields fields) {
        return new GroupOperation(fields);
    }

    public static SortOperation sort(Sort sort) {
        return new SortOperation(sort);
    }

    public static SortOperation sort(Sort.Direction direction, String ... fields) {
        return new SortOperation(new Sort(direction, fields));
    }

    public static SkipOperation skip(int elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static SkipOperation skip(long elementsToSkip) {
        return new SkipOperation(elementsToSkip);
    }

    public static LimitOperation limit(long maxElements) {
        return new LimitOperation(maxElements);
    }

    public static MatchOperation match(Criteria criteria) {
        return new MatchOperation(criteria);
    }

    public static LookupOperation lookup(String from, String localField, String foreignField, String as) {
        return Aggregation.lookup(Fields.field(from), Fields.field(localField), Fields.field(foreignField), Fields.field(as));
    }

    public static LookupOperation lookup(Field from, Field localField, Field foreignField, Field as) {
        return new LookupOperation(from, localField, foreignField, as);
    }

    public static Fields fields(String ... fields) {
        return Fields.fields(fields);
    }

    public static Fields bind(String name, String target) {
        return Fields.from(Fields.field(name, target));
    }

    public static GeoNearOperation geoNear(NearQuery query, String distanceField) {
        return new GeoNearOperation(query, distanceField);
    }

    public static AggregationOptions.Builder newAggregationOptions() {
        return new AggregationOptions.Builder();
    }

    public DBObject toDbObject(String inputCollectionName, AggregationOperationContext rootContext) {
        AggregationOperationContext context = rootContext;
        ArrayList<DBObject> operationDocuments = new ArrayList<DBObject>(this.operations.size());
        for (AggregationOperation operation : this.operations) {
            operationDocuments.add(operation.toDBObject(context));
            if (!(operation instanceof FieldsExposingAggregationOperation)) continue;
            FieldsExposingAggregationOperation exposedFieldsOperation = (FieldsExposingAggregationOperation)operation;
            if (operation instanceof FieldsExposingAggregationOperation.InheritsFieldsAggregationOperation) {
                context = new InheritingExposedFieldsAggregationOperationContext(exposedFieldsOperation.getFields(), context);
                continue;
            }
            context = new ExposedFieldsAggregationOperationContext(exposedFieldsOperation.getFields(), context);
        }
        BasicDBObject command = new BasicDBObject("aggregate", (Object)inputCollectionName);
        command.put("pipeline", operationDocuments);
        command = this.options.applyAndReturnPotentiallyChangedCommand((DBObject)command);
        return command;
    }

    public String toString() {
        return SerializationUtils.serializeToJsonSafely(this.toDbObject("__collection__", new NoOpAggregationOperationContext()));
    }

    static enum SystemVariable {
        ROOT,
        CURRENT;

        private static final String PREFIX = "$$";

        public static boolean isReferingToSystemVariable(String fieldRef) {
            if (fieldRef == null || !fieldRef.startsWith(PREFIX) || fieldRef.length() <= 2) {
                return false;
            }
            int indexOfFirstDot = fieldRef.indexOf(46);
            String candidate = fieldRef.substring(2, indexOfFirstDot == -1 ? fieldRef.length() : indexOfFirstDot);
            for (SystemVariable value : SystemVariable.values()) {
                if (!value.name().equals(candidate)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return PREFIX.concat(this.name());
        }
    }

    private static class NoOpAggregationOperationContext
    implements AggregationOperationContext {
        private NoOpAggregationOperationContext() {
        }

        @Override
        public DBObject getMappedObject(DBObject dbObject) {
            return dbObject;
        }

        @Override
        public ExposedFields.FieldReference getReference(Field field) {
            return new ExposedFields.FieldReference(new ExposedFields.ExposedField(field, true));
        }

        @Override
        public ExposedFields.FieldReference getReference(String name) {
            return new ExposedFields.FieldReference(new ExposedFields.ExposedField(new Fields.AggregationField(name), true));
        }
    }
}

