/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.ExposedFieldsAggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.util.Assert;

class InheritingExposedFieldsAggregationOperationContext
extends ExposedFieldsAggregationOperationContext {
    private final AggregationOperationContext previousContext;

    public InheritingExposedFieldsAggregationOperationContext(ExposedFields exposedFields, AggregationOperationContext previousContext) {
        super(exposedFields, previousContext);
        Assert.notNull((Object)previousContext, (String)"PreviousContext must not be null!");
        this.previousContext = previousContext;
    }

    @Override
    protected ExposedFields.FieldReference resolveExposedField(Field field, String name) {
        ExposedFields.FieldReference fieldReference = super.resolveExposedField(field, name);
        if (fieldReference != null) {
            return fieldReference;
        }
        if (field != null) {
            return this.previousContext.getReference(field);
        }
        return this.previousContext.getReference(name);
    }
}

