/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.util.Assert;

public class UpdateMapper
extends QueryMapper {
    private final MongoConverter converter;

    public UpdateMapper(MongoConverter converter) {
        super(converter);
        this.converter = converter;
    }

    @Override
    protected Object delegateConvertToMongoType(Object source, MongoPersistentEntity<?> entity) {
        return entity == null ? super.delegateConvertToMongoType(source, null) : this.converter.convertToMongoType(source, entity.getTypeInformation());
    }

    @Override
    protected Map.Entry<String, Object> getMappedObjectForField(QueryMapper.Field field, Object rawValue) {
        if (this.isDBObject(rawValue)) {
            return this.createMapEntry(field, this.convertSimpleOrDBObject(rawValue, field.getPropertyEntity()));
        }
        if (!this.isUpdateModifier(rawValue)) {
            return super.getMappedObjectForField(field, this.getMappedValue(field, rawValue));
        }
        DBObject value = null;
        if (rawValue instanceof Update.Modifier) {
            value = this.getMappedValue((Update.Modifier)rawValue);
        } else if (rawValue instanceof Update.Modifiers) {
            BasicDBObject modificationOperations = new BasicDBObject();
            for (Update.Modifier modifier : ((Update.Modifiers)rawValue).getModifiers()) {
                modificationOperations.putAll(this.getMappedValue(modifier).toMap());
            }
            value = modificationOperations;
        } else {
            throw new IllegalArgumentException(String.format("Unable to map value of type '%s'!", rawValue.getClass()));
        }
        return this.createMapEntry(field, value);
    }

    @Override
    protected boolean isAssociationConversionNecessary(QueryMapper.Field documentField, Object value) {
        return super.isAssociationConversionNecessary(documentField, value) || documentField.containsAssociation();
    }

    private boolean isUpdateModifier(Object value) {
        return value instanceof Update.Modifier || value instanceof Update.Modifiers;
    }

    private DBObject getMappedValue(Update.Modifier modifier) {
        Object value = this.converter.convertToMongoType(modifier.getValue(), ClassTypeInformation.OBJECT);
        return new BasicDBObject(modifier.getKey(), value);
    }

    @Override
    protected QueryMapper.Field createPropertyField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? super.createPropertyField(entity, key, mappingContext) : new MetadataBackedUpdateField(entity, key, mappingContext);
    }

    private static class MetadataBackedUpdateField
    extends QueryMapper.MetadataBackedField {
        private final String key;

        public MetadataBackedUpdateField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super(key.replaceAll("\\.\\$", ""), entity, mappingContext);
            this.key = key;
        }

        @Override
        public String getMappedKey() {
            return this.getPath() == null ? this.key : super.getMappedKey();
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return this.isAssociation() ? new AssociationConverter(this.getAssociation()) : new UpdatePropertyConverter(this.key);
        }

        private static class UpdatePropertyConverter
        implements Converter<MongoPersistentProperty, String> {
            private final Iterator<String> iterator;

            public UpdatePropertyConverter(String updateKey) {
                Assert.hasText((String)updateKey, (String)"Update key must not be null or empty!");
                this.iterator = Arrays.asList(updateKey.split("\\.")).iterator();
                this.iterator.next();
            }

            public String convert(MongoPersistentProperty property) {
                String mappedName = MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE.convert(property);
                return this.iterator.hasNext() && this.iterator.next().equals("$") ? String.format("%s.$", mappedName) : mappedName;
            }
        }

        private static class AssociationConverter
        implements Converter<MongoPersistentProperty, String> {
            private final MongoPersistentProperty property;
            private boolean associationFound;

            public AssociationConverter(Association<MongoPersistentProperty> association) {
                Assert.notNull(association, (String)"Association must not be null!");
                this.property = (MongoPersistentProperty)association.getInverse();
            }

            public String convert(MongoPersistentProperty source) {
                if (this.associationFound) {
                    return null;
                }
                if (this.property.equals(source)) {
                    this.associationFound = true;
                }
                return source.getFieldName();
            }
        }
    }
}

