/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import com.mongodb.DBObject;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatingMongoEventListener
extends AbstractMongoEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingMongoEventListener.class);
    private final Validator validator;

    public ValidatingMongoEventListener(Validator validator) {
        Assert.notNull((Object)validator);
        this.validator = validator;
    }

    @Override
    public void onBeforeSave(Object source, DBObject dbo) {
        LOG.debug("Validating object: {}", source);
        Set violations = this.validator.validate(source, new Class[0]);
        if (!violations.isEmpty()) {
            LOG.info("During object: {} validation violations found: {}", source, (Object)violations);
            throw new ConstraintViolationException(violations);
        }
    }
}

