/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.mapping.BasicMongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.CachingMongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.data.util.TypeInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoMappingContext
extends AbstractMappingContext<BasicMongoPersistentEntity<?>, MongoPersistentProperty>
implements ApplicationContextAware {
    private ApplicationContext context;

    public MongoMappingContext() {
        this.setSimpleTypeHolder(MongoSimpleTypes.HOLDER);
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return !MongoSimpleTypes.HOLDER.isSimpleType(type.getType());
    }

    public MongoPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, BasicMongoPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new CachingMongoPersistentProperty(field, descriptor, owner, simpleTypeHolder);
    }

    protected <T> BasicMongoPersistentEntity<T> createPersistentEntity(TypeInformation<T> typeInformation) {
        BasicMongoPersistentEntity<T> entity = new BasicMongoPersistentEntity<T>(typeInformation);
        if (this.context != null) {
            entity.setApplicationContext(this.context);
        }
        return entity;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
        super.setApplicationContext(applicationContext);
    }
}

