/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import com.mongodb.DBObject;
import java.util.Collections;
import java.util.List;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.util.Assert;

public class AccumulatorOperators {
    public static AccumulatorOperatorFactory valueOf(String fieldReference) {
        return new AccumulatorOperatorFactory(fieldReference);
    }

    public static AccumulatorOperatorFactory valueOf(AggregationExpression expression) {
        return new AccumulatorOperatorFactory(expression);
    }

    public static class StdDevSamp
    extends AbstractAggregationExpression {
        private StdDevSamp(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$stdDevSamp";
        }

        public static StdDevSamp stdDevSampOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StdDevSamp(StdDevSamp.asFields(fieldReference));
        }

        public static StdDevSamp stdDevSampOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StdDevSamp(Collections.singletonList(expression));
        }

        public StdDevSamp and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StdDevSamp(this.append(Fields.field(fieldReference)));
        }

        public StdDevSamp and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StdDevSamp(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class StdDevPop
    extends AbstractAggregationExpression {
        private StdDevPop(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$stdDevPop";
        }

        public static StdDevPop stdDevPopOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StdDevPop(StdDevPop.asFields(fieldReference));
        }

        public static StdDevPop stdDevPopOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StdDevPop(Collections.singletonList(expression));
        }

        public StdDevPop and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new StdDevPop(this.append(Fields.field(fieldReference)));
        }

        public StdDevPop and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new StdDevPop(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class Min
    extends AbstractAggregationExpression {
        private Min(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$min";
        }

        public static Min minOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Min(Min.asFields(fieldReference));
        }

        public static Min minOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Min(Collections.singletonList(expression));
        }

        public Min and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Min(this.append(Fields.field(fieldReference)));
        }

        public Min and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Min(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class Max
    extends AbstractAggregationExpression {
        private Max(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$max";
        }

        public static Max maxOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Max(Max.asFields(fieldReference));
        }

        public static Max maxOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Max(Collections.singletonList(expression));
        }

        public Max and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Max(this.append(Fields.field(fieldReference)));
        }

        public Max and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Max(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class Avg
    extends AbstractAggregationExpression {
        private Avg(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$avg";
        }

        public static Avg avgOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Avg(Avg.asFields(fieldReference));
        }

        public static Avg avgOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Avg(Collections.singletonList(expression));
        }

        public Avg and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Avg(this.append(Fields.field(fieldReference)));
        }

        public Avg and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Avg(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class Sum
    extends AbstractAggregationExpression {
        private Sum(Object value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$sum";
        }

        public static Sum sumOf(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Sum(Sum.asFields(fieldReference));
        }

        public static Sum sumOf(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Sum(Collections.singletonList(expression));
        }

        public Sum and(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            return new Sum(this.append(Fields.field(fieldReference)));
        }

        public Sum and(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            return new Sum(this.append(expression));
        }

        @Override
        public DBObject toDbObject(Object value, AggregationOperationContext context) {
            if (value instanceof List && ((List)value).size() == 1) {
                return super.toDbObject(((List)value).iterator().next(), context);
            }
            return super.toDbObject(value, context);
        }
    }

    public static class AccumulatorOperatorFactory {
        private final String fieldReference;
        private final AggregationExpression expression;

        public AccumulatorOperatorFactory(String fieldReference) {
            Assert.notNull((Object)fieldReference, (String)"FieldReference must not be null!");
            this.fieldReference = fieldReference;
            this.expression = null;
        }

        public AccumulatorOperatorFactory(AggregationExpression expression) {
            Assert.notNull((Object)expression, (String)"Expression must not be null!");
            this.fieldReference = null;
            this.expression = expression;
        }

        public Sum sum() {
            return this.usesFieldRef() ? Sum.sumOf(this.fieldReference) : Sum.sumOf(this.expression);
        }

        public Avg avg() {
            return this.usesFieldRef() ? Avg.avgOf(this.fieldReference) : Avg.avgOf(this.expression);
        }

        public Max max() {
            return this.usesFieldRef() ? Max.maxOf(this.fieldReference) : Max.maxOf(this.expression);
        }

        public Min min() {
            return this.usesFieldRef() ? Min.minOf(this.fieldReference) : Min.minOf(this.expression);
        }

        public StdDevPop stdDevPop() {
            return this.usesFieldRef() ? StdDevPop.stdDevPopOf(this.fieldReference) : StdDevPop.stdDevPopOf(this.expression);
        }

        public StdDevSamp stdDevSamp() {
            return this.usesFieldRef() ? StdDevSamp.stdDevSampOf(this.fieldReference) : StdDevSamp.stdDevSampOf(this.expression);
        }

        private boolean usesFieldRef() {
            return this.fieldReference != null;
        }
    }
}

