/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.query;

import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.ldap.repository.Query;
import org.springframework.data.ldap.repository.query.AbstractLdapRepositoryQuery;
import org.springframework.data.ldap.repository.query.LdapParameterAccessor;
import org.springframework.data.ldap.repository.query.LdapQueryMethod;
import org.springframework.data.ldap.repository.query.StringBasedQuery;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class AnnotatedLdapRepositoryQuery
extends AbstractLdapRepositoryQuery {
    private final Query queryAnnotation;
    private final StringBasedQuery query;
    private final StringBasedQuery base;
    private final ValueEvaluationContextProvider valueContextProvider;

    @Deprecated(since="3.4")
    public AnnotatedLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators) {
        this(queryMethod, entityType, ldapOperations, mappingContext, instantiators, ValueExpressionDelegate.create());
    }

    public AnnotatedLdapRepositoryQuery(LdapQueryMethod queryMethod, Class<?> entityType, LdapOperations ldapOperations, MappingContext<? extends PersistentEntity<?, ?>, ? extends PersistentProperty<?>> mappingContext, EntityInstantiators instantiators, ValueExpressionDelegate valueExpressionDelegate) {
        super(queryMethod, entityType, ldapOperations, mappingContext, instantiators);
        Assert.notNull((Object)queryMethod.getQueryAnnotation(), (String)"Annotation must be present");
        Assert.hasLength((String)queryMethod.getQueryAnnotation().value(), (String)"Query filter must be specified");
        this.queryAnnotation = queryMethod.getRequiredQueryAnnotation();
        this.query = new StringBasedQuery(this.queryAnnotation.value(), queryMethod.getParameters(), valueExpressionDelegate);
        this.base = new StringBasedQuery(this.queryAnnotation.base(), queryMethod.getParameters(), valueExpressionDelegate);
        this.valueContextProvider = valueExpressionDelegate.createValueContextProvider(this.getQueryMethod().getParameters());
    }

    @Override
    protected LdapQuery createQuery(LdapParameterAccessor parameters) {
        String query = this.bind(parameters, this.valueContextProvider, this.query);
        String base = this.bind(parameters, this.valueContextProvider, this.base);
        return LdapQueryBuilder.query().base(base).searchScope(this.queryAnnotation.searchScope()).countLimit(this.queryAnnotation.countLimit()).timeLimit(this.queryAnnotation.timeLimit()).filter(query, parameters.getBindableParameterValues());
    }

    private String bind(LdapParameterAccessor parameters, ValueEvaluationContextProvider valueContextProvider, StringBasedQuery query) {
        ValueEvaluationContext evaluationContext = valueContextProvider.getEvaluationContext((Object)parameters.getBindableParameterValues(), query.getExpressionDependencies());
        return query.bindQuery(parameters, expression -> expression.evaluate(evaluationContext));
    }
}

