/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import com.querydsl.core.DefaultQueryMetadata;
import com.querydsl.core.FilteredClause;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.support.QueryMixin;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.data.ldap.repository.support.LdapSerializer;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.filter.AbsoluteTrueFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.query.LdapQuery;
import org.springframework.ldap.query.LdapQueryBuilder;
import org.springframework.util.Assert;

public class QuerydslLdapQuery<K>
implements FilteredClause<QuerydslLdapQuery<K>> {
    private final LdapOperations ldapOperations;
    private final Class<K> entityType;
    private final LdapSerializer filterGenerator;
    private final Consumer<LdapQueryBuilder> queryCustomizer;
    private QueryMixin<QuerydslLdapQuery<K>> queryMixin = new QueryMixin((Object)this, (QueryMetadata)new DefaultQueryMetadata().noValidate());

    public QuerydslLdapQuery(LdapOperations ldapOperations, EntityPath<K> entityPath) {
        this(ldapOperations, entityPath.getType());
    }

    public QuerydslLdapQuery(LdapOperations ldapOperations, Class<K> entityType) {
        this(ldapOperations, entityType, it -> {});
    }

    public QuerydslLdapQuery(LdapOperations ldapOperations, Class<K> entityType, Consumer<LdapQueryBuilder> queryCustomizer) {
        Assert.notNull((Object)ldapOperations, (String)"LdapOperations must not be null!");
        Assert.notNull(entityType, (String)"Type must not be null!");
        Assert.notNull(queryCustomizer, (String)"Query customizer must not be null!");
        this.ldapOperations = ldapOperations;
        this.entityType = entityType;
        this.queryCustomizer = queryCustomizer;
        this.filterGenerator = new LdapSerializer(ldapOperations.getObjectDirectoryMapper(), this.entityType);
    }

    public QuerydslLdapQuery<K> where(Predicate ... o) {
        if (o == null) {
            return this;
        }
        return (QuerydslLdapQuery)this.queryMixin.where(o);
    }

    public List<K> list() {
        LdapQuery ldapQuery = this.buildQuery();
        if (ldapQuery.filter() instanceof AbsoluteTrueFilter) {
            return this.ldapOperations.findAll(this.entityType);
        }
        return this.ldapOperations.find(ldapQuery, this.entityType);
    }

    <T> List<T> search(ContextMapper<T> mapper) {
        LdapQuery ldapQuery = this.buildQuery();
        return this.ldapOperations.search(ldapQuery, mapper);
    }

    public K uniqueResult() {
        return (K)this.ldapOperations.findOne(this.buildQuery(), this.entityType);
    }

    LdapQuery buildQuery() {
        Predicate where = this.queryMixin.getMetadata().getWhere();
        LdapQueryBuilder builder = LdapQueryBuilder.query();
        this.queryCustomizer.accept(builder);
        return where != null ? builder.filter(this.filterGenerator.handle((Expression<?>)where)) : builder.filter((Filter)new AbsoluteTrueFilter());
    }
}

