/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.ldap.repository.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.List;
import java.util.Optional;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.ldap.repository.support.QuerydslLdapQuery;
import org.springframework.data.ldap.repository.support.SimpleLdapRepository;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;

public class QuerydslLdapRepository<T>
extends SimpleLdapRepository<T>
implements QuerydslPredicateExecutor<T> {
    private final LdapOperations ldapOperations;
    private final Class<T> entityType;

    public QuerydslLdapRepository(LdapOperations ldapOperations, ObjectDirectoryMapper odm, Class<T> entityType) {
        super(ldapOperations, odm, entityType);
        this.ldapOperations = ldapOperations;
        this.entityType = entityType;
    }

    public Optional<T> findOne(Predicate predicate) {
        try {
            return Optional.of(this.queryFor(predicate).uniqueResult());
        }
        catch (EmptyResultDataAccessException o_O) {
            return Optional.empty();
        }
    }

    public List<T> findAll(Predicate predicate) {
        return this.queryFor(predicate).list();
    }

    public long count(Predicate predicate) {
        return this.findAll(predicate).size();
    }

    public boolean exists(Predicate predicate) {
        return this.count(predicate) > 0L;
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        throw new UnsupportedOperationException();
    }

    private QuerydslLdapQuery<T> queryFor(Predicate predicate) {
        return new QuerydslLdapQuery<T>(this.ldapOperations, this.entityType).where(new Predicate[]{predicate});
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        throw new UnsupportedOperationException();
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        throw new UnsupportedOperationException();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        throw new UnsupportedOperationException();
    }
}

