/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.query;

import java.lang.reflect.Constructor;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.expression.ValueEvaluationContext;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.core.SpelCriteria;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Lazy;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class KeyValuePartTreeQuery
implements RepositoryQuery {
    private final Lazy<PartTree> partTree;
    private final QueryMethod queryMethod;
    private final KeyValueOperations keyValueOperations;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> queryCreatorFactory;
    private final ValueEvaluationContextProvider evaluationContextProvider;

    public KeyValuePartTreeQuery(QueryMethod queryMethod, ValueExpressionDelegate valueExpressionDelegate, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        this(queryMethod, valueExpressionDelegate, keyValueOperations, new ConstructorCachingQueryCreatorFactory(queryCreator));
    }

    public KeyValuePartTreeQuery(QueryMethod queryMethod, ValueExpressionDelegate valueExpressionDelegate, KeyValueOperations keyValueOperations, QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> queryCreatorFactory) {
        Assert.notNull((Object)queryMethod, (String)"Query method must not be null");
        Assert.notNull((Object)valueExpressionDelegate, (String)"ValueExpressionDelegate must not be null");
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null");
        Assert.notNull(queryCreatorFactory, (String)"QueryCreatorFactory type must not be null");
        this.partTree = Lazy.of(() -> new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType()));
        this.queryMethod = queryMethod;
        this.keyValueOperations = keyValueOperations;
        this.valueExpressionDelegate = valueExpressionDelegate;
        this.queryCreatorFactory = queryCreatorFactory;
        this.evaluationContextProvider = valueExpressionDelegate.createValueContextProvider(queryMethod.getParameters());
    }

    public @Nullable Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        KeyValueQuery<?> query = this.prepareQuery(parameters);
        ResultProcessor processor = this.queryMethod.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        return processor.processResult(this.doExecute(parameters, query));
    }

    protected @Nullable Object doExecute(Object[] parameters, KeyValueQuery<?> query) {
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable page = (Pageable)parameters[this.queryMethod.getParameters().getPageableIndex()];
            query.setOffset(page.getOffset());
            query.setRows(page.getPageSize());
            Iterable result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
            long count = this.queryMethod.isSliceQuery() ? 0L : this.keyValueOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
            return new PageImpl(IterableConverter.toList(result), page, count);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (((PartTree)this.partTree.get()).isExistsProjection()) {
            return this.keyValueOperations.exists(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        if (((PartTree)this.partTree.get()).isCountProjection()) {
            return this.keyValueOperations.count(query, this.queryMethod.getEntityInformation().getJavaType());
        }
        Iterable result = this.keyValueOperations.find(query, this.queryMethod.getEntityInformation().getJavaType());
        return result.iterator().hasNext() ? result.iterator().next() : null;
    }

    protected KeyValueQuery<?> prepareQuery(Object[] parameters) {
        return this.prepareQuery(this.createQuery((ParameterAccessor)new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters)), parameters);
    }

    protected KeyValueQuery<?> prepareQuery(KeyValueQuery<?> instance, Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.getQueryMethod().getParameters(), parameters);
        Object criteria = instance.getCriteria();
        if (criteria instanceof SpelCriteria || criteria instanceof SpelExpression) {
            SpelExpression spelExpression = this.getSpelExpression(criteria);
            ValueEvaluationContext context = this.evaluationContextProvider.getEvaluationContext((Object)parameters);
            criteria = new SpelCriteria(spelExpression, context.getRequiredEvaluationContext());
        }
        KeyValueQuery query = new KeyValueQuery(criteria);
        Pageable pageable = accessor.getPageable();
        Sort sort = accessor.getSort();
        query.setOffset(pageable.toOptional().map(Pageable::getOffset).orElse(-1L));
        if (pageable.isPaged()) {
            query.setRows(pageable.getPageSize());
        } else if (instance.getRows() >= 0) {
            query.setRows(instance.getRows());
        }
        query.setSort(sort.isUnsorted() ? instance.getSort() : sort);
        return query;
    }

    private SpelExpression getSpelExpression(Object criteria) {
        if (criteria instanceof SpelExpression) {
            return (SpelExpression)criteria;
        }
        if (criteria instanceof SpelCriteria) {
            return this.getSpelExpression(((SpelCriteria)criteria).getExpression());
        }
        throw new IllegalStateException(String.format("Cannot retrieve SpelExpression from %s", criteria));
    }

    public KeyValueQuery<?> createQuery(ParameterAccessor accessor) {
        PartTree tree = (PartTree)this.partTree.get();
        AbstractQueryCreator<KeyValueQuery<?>, ?> queryCreator = this.queryCreatorFactory.queryCreatorFor(tree, accessor);
        KeyValueQuery query = (KeyValueQuery)queryCreator.createQuery();
        if (tree.isLimiting()) {
            query.setRows(tree.getMaxResults());
        }
        return query;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private static class ConstructorCachingQueryCreatorFactory
    implements QueryCreatorFactory<AbstractQueryCreator<KeyValueQuery<?>, ?>> {
        private final Class<?> type;
        private final @Nullable Constructor<? extends AbstractQueryCreator<?, ?>> constructor;

        ConstructorCachingQueryCreatorFactory(Class<? extends AbstractQueryCreator<?, ?>> type) {
            this.type = type;
            this.constructor = ClassUtils.getConstructorIfAvailable(type, (Class[])new Class[]{PartTree.class, ParameterAccessor.class});
        }

        @Override
        public AbstractQueryCreator<KeyValueQuery<?>, ?> queryCreatorFor(PartTree partTree, ParameterAccessor accessor) {
            Assert.state((this.constructor != null ? 1 : 0) != 0, () -> String.format("No constructor (PartTree, ParameterAccessor) could be found on type %s", this.type));
            return (AbstractQueryCreator)BeanUtils.instantiateClass(this.constructor, (Object[])new Object[]{partTree, accessor});
        }
    }

    public static interface QueryCreatorFactory<T extends AbstractQueryCreator<?, ?>> {
        public T queryCreatorFor(PartTree var1, ParameterAccessor var2);
    }
}

