/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.Collection;
import java.util.Optional;
import org.springframework.data.keyvalue.core.CriteriaAccessor;
import org.springframework.data.keyvalue.core.KeyValueAdapter;
import org.springframework.data.keyvalue.core.SortAccessor;
import org.springframework.data.keyvalue.core.query.KeyValueQuery;
import org.springframework.lang.Nullable;

public abstract class QueryEngine<ADAPTER extends KeyValueAdapter, CRITERIA, SORT> {
    private final Optional<CriteriaAccessor<CRITERIA>> criteriaAccessor;
    private final Optional<SortAccessor<SORT>> sortAccessor;
    @Nullable
    private ADAPTER adapter;

    public QueryEngine(@Nullable CriteriaAccessor<CRITERIA> criteriaAccessor, @Nullable SortAccessor<SORT> sortAccessor) {
        this.criteriaAccessor = Optional.ofNullable(criteriaAccessor);
        this.sortAccessor = Optional.ofNullable(sortAccessor);
    }

    public Collection<?> execute(KeyValueQuery<?> query, String keyspace) {
        CRITERIA criteria = this.criteriaAccessor.map(it -> it.resolve(query)).orElse(null);
        SORT sort = this.sortAccessor.map(it -> it.resolve(query)).orElse(null);
        return this.execute(criteria, sort, query.getOffset(), query.getRows(), keyspace);
    }

    public <T> Collection<T> execute(KeyValueQuery<?> query, String keyspace, Class<T> type) {
        CRITERIA criteria = this.criteriaAccessor.map(it -> it.resolve(query)).orElse(null);
        SORT sort = this.sortAccessor.map(it -> it.resolve(query)).orElse(null);
        return this.execute(criteria, sort, query.getOffset(), query.getRows(), keyspace, type);
    }

    public long count(KeyValueQuery<?> query, String keyspace) {
        CRITERIA criteria = this.criteriaAccessor.map(it -> it.resolve(query)).orElse(null);
        return this.count(criteria, keyspace);
    }

    public abstract Collection<?> execute(@Nullable CRITERIA var1, @Nullable SORT var2, long var3, int var5, String var6);

    public <T> Collection<T> execute(@Nullable CRITERIA criteria, @Nullable SORT sort, long offset, int rows, String keyspace, Class<T> type) {
        return this.execute(criteria, sort, offset, rows, keyspace);
    }

    public abstract long count(@Nullable CRITERIA var1, String var2);

    @Nullable
    protected ADAPTER getAdapter() {
        return this.adapter;
    }

    protected ADAPTER getRequiredAdapter() {
        ADAPTER adapter = this.getAdapter();
        if (adapter != null) {
            return adapter;
        }
        throw new IllegalStateException("Required KeyValueAdapter is not set");
    }

    public void registerAdapter(KeyValueAdapter adapter) {
        if (this.adapter != null) {
            throw new IllegalArgumentException("Cannot register more than one adapter for this QueryEngine");
        }
        this.adapter = adapter;
    }
}

