/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.support;

import java.io.Serializable;
import java.lang.reflect.Method;
import org.springframework.data.keyvalue.core.KeyValueOperations;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.QuerydslKeyValueRepository;
import org.springframework.data.keyvalue.repository.support.SimpleKeyValueRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.EvaluationContextProvider;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.util.Assert;

public class KeyValueRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<SpelQueryCreator> DEFAULT_QUERY_CREATOR = SpelQueryCreator.class;
    private final KeyValueOperations keyValueOperations;
    private final MappingContext<?, ?> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    public KeyValueRepositoryFactory(KeyValueOperations keyValueOperations) {
        this(keyValueOperations, DEFAULT_QUERY_CREATOR);
    }

    public KeyValueRepositoryFactory(KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.queryCreator = queryCreator;
        this.keyValueOperations = keyValueOperations;
        this.context = keyValueOperations.getMappingContext();
    }

    public <T, ID extends Serializable> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        PersistentEntity entity = this.context.getPersistentEntity(domainClass);
        PersistentEntityInformation entityInformation = new PersistentEntityInformation(entity);
        return entityInformation;
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.keyValueOperations});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return KeyValueRepositoryFactory.isQueryDslRepository(metadata.getRepositoryInterface()) ? QuerydslKeyValueRepository.class : SimpleKeyValueRepository.class;
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QueryDslUtils.QUERY_DSL_PRESENT && QueryDslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    protected QueryLookupStrategy getQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider) {
        return new KeyValueQueryLookupStrategy(key, evaluationContextProvider, this.keyValueOperations, this.queryCreator);
    }

    private static class KeyValueQueryLookupStrategy
    implements QueryLookupStrategy {
        private EvaluationContextProvider evaluationContextProvider;
        private KeyValueOperations keyValueOperations;
        private Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

        public KeyValueQueryLookupStrategy(QueryLookupStrategy.Key key, EvaluationContextProvider evaluationContextProvider, KeyValueOperations keyValueOperations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
            Assert.notNull((Object)evaluationContextProvider, (String)"EvaluationContextProvider must not be null!");
            Assert.notNull((Object)keyValueOperations, (String)"KeyValueOperations must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            this.evaluationContextProvider = evaluationContextProvider;
            this.keyValueOperations = keyValueOperations;
            this.queryCreator = queryCreator;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata);
            return new KeyValuePartTreeQuery(queryMethod, this.evaluationContextProvider, this.keyValueOperations, this.queryCreator);
        }
    }
}

