/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.Bindable;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.data.core.PropertyPath;
import org.springframework.data.jpa.repository.query.ExpressionFactorySupport;
import org.springframework.data.jpa.repository.query.JpqlQueryBuilder;
import org.springframework.util.Assert;

class JpqlUtils {
    JpqlUtils() {
    }

    static JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property) {
        return JpqlUtils.toExpressionRecursively(metamodel, source, from, property, false);
    }

    static JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property, boolean isForSelection) {
        return JpqlExpressionFactory.INSTANCE.toExpressionRecursively(metamodel, source, from, property, isForSelection, false);
    }

    static class JpqlExpressionFactory
    extends ExpressionFactorySupport {
        private static final JpqlExpressionFactory INSTANCE = new JpqlExpressionFactory();

        JpqlExpressionFactory() {
        }

        public JpqlQueryBuilder.PathExpression toExpressionRecursively(Metamodel metamodel, JpqlQueryBuilder.Origin source, Bindable<?> from, PropertyPath property, boolean isForSelection, boolean hasRequiredOuterJoin) {
            JpqlQueryBuilder.Join joinSource;
            boolean isRelationshipId;
            String segment = property.getSegment();
            BindablePathResolver resolver = new BindablePathResolver(metamodel, from);
            boolean isLeafProperty = !property.hasNext();
            boolean requiresOuterJoin = this.requiresOuterJoin(resolver, property, isForSelection, hasRequiredOuterJoin, isLeafProperty, isRelationshipId = this.isRelationshipId(resolver, property));
            if (!requiresOuterJoin && (isLeafProperty || isRelationshipId)) {
                return new JpqlQueryBuilder.PathAndOrigin(property, source, false);
            }
            JpqlQueryBuilder.Join join = joinSource = requiresOuterJoin ? JpqlQueryBuilder.leftJoin(source, segment) : JpqlQueryBuilder.innerJoin(source, segment);
            if (isLeafProperty) {
                return new JpqlQueryBuilder.PathAndOrigin(property, joinSource, true);
            }
            PropertyPath nextProperty = Objects.requireNonNull(property.next(), "An element of the property path is null");
            Attribute<?, ?> nextAttribute = JpqlExpressionFactory.resolveAttribute(metamodel, from, property);
            if (nextAttribute == null) {
                throw new IllegalStateException("Binding property is null");
            }
            return this.toExpressionRecursively(metamodel, joinSource, (Bindable)nextAttribute, nextProperty, isForSelection, requiresOuterJoin);
        }

        @Nullable
        private static Attribute<?, ?> resolveAttribute(Metamodel metamodel, Bindable<?> from, PropertyPath property) {
            ManagedType<?> managedType = JpqlExpressionFactory.getManagedTypeForModel(from);
            return JpqlExpressionFactory.getModelForPath(metamodel, property, managedType, from);
        }

        @Nullable
        private static Attribute<?, ?> getModelForPath(@Nullable Metamodel metamodel, PropertyPath path, @Nullable ManagedType<?> managedType, @Nullable Bindable<?> fallback) {
            String segment = path.getSegment();
            if (managedType != null) {
                try {
                    return managedType.getAttribute(segment);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            if (metamodel != null && fallback != null) {
                Class fallbackType = fallback.getBindableJavaType();
                try {
                    return metamodel.managedType(fallbackType).getAttribute(segment);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
            return null;
        }

        record BindablePathResolver(Metamodel metamodel, Bindable<?> bindable) implements ExpressionFactorySupport.ModelPathResolver
        {
            @Override
            @Nullable
            public Bindable<?> resolve(PropertyPath propertyPath) {
                Bindable b;
                Attribute<?, ?> attribute = this.resolveAttribute(propertyPath);
                return attribute instanceof Bindable ? (b = (Bindable)attribute) : null;
            }

            @Nullable
            private Attribute<?, ?> resolveAttribute(PropertyPath propertyPath) {
                return JpqlExpressionFactory.resolveAttribute(this.metamodel, this.bindable, propertyPath);
            }

            @Override
            @Nullable
            public Bindable<?> resolveNext(PropertyPath propertyPath) {
                Bindable b;
                Assert.state((boolean)propertyPath.hasNext(), (String)"PropertyPath must contain at least one element");
                Attribute<?, ?> propertyPathModel = this.resolveAttribute(propertyPath);
                ManagedType<?> propertyPathManagedType = JpqlExpressionFactory.getManagedTypeForModel(propertyPathModel);
                Attribute<?, ?> next = JpqlExpressionFactory.getModelForPath(this.metamodel, Objects.requireNonNull(propertyPath.next()), propertyPathManagedType, null);
                return next instanceof Bindable ? (b = (Bindable)next) : null;
            }
        }
    }
}

