/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Tuple;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.metamodel.Metamodel;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.aot.AotQueries;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.aot.NamedAotQuery;
import org.springframework.data.jpa.repository.aot.StringAotQuery;
import org.springframework.data.jpa.repository.config.JpaRepositoryConfigExtension;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.EntityQuery;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterMetadataProvider;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.config.PropertiesBasedNamedQueriesFactoryBean;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.PropertiesBasedNamedQueries;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class QueriesFactory {
    private final EntityManagerFactory entityManagerFactory;
    private final NamedQueries namedQueries;
    private final Metamodel metamodel;
    private final EscapeCharacter escapeCharacter;
    private final JpqlQueryTemplates templates = JpqlQueryTemplates.UPPER;

    public QueriesFactory(RepositoryConfigurationSource configurationSource, EntityManagerFactory entityManagerFactory, ClassLoader classLoader) {
        this(configurationSource, entityManagerFactory, entityManagerFactory.getMetamodel(), classLoader);
    }

    public QueriesFactory(RepositoryConfigurationSource configurationSource, EntityManagerFactory entityManagerFactory, Metamodel metamodel, ClassLoader classLoader) {
        this.metamodel = metamodel;
        this.namedQueries = this.getNamedQueries(configurationSource, classLoader);
        this.entityManagerFactory = entityManagerFactory;
        Optional escapeCharacter = configurationSource.getAttribute("escapeCharacter", Character.class);
        this.escapeCharacter = escapeCharacter.map(EscapeCharacter::of).orElse(EscapeCharacter.DEFAULT);
    }

    private NamedQueries getNamedQueries(@Nullable RepositoryConfigurationSource configSource, ClassLoader classLoader) {
        String location;
        String string = location = configSource != null ? (String)configSource.getNamedQueryLocation().orElse(null) : null;
        if (location == null) {
            location = new JpaRepositoryConfigExtension().getDefaultNamedQueryLocation();
        }
        if (StringUtils.hasText((String)location)) {
            try {
                PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
                PropertiesBasedNamedQueriesFactoryBean factoryBean = new PropertiesBasedNamedQueriesFactoryBean();
                factoryBean.setLocations(resolver.getResources(location));
                factoryBean.afterPropertiesSet();
                return factoryBean.getObject();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new PropertiesBasedNamedQueries(new Properties());
    }

    public AotQueries createQueries(RepositoryInformation repositoryInformation, MergedAnnotation<Query> query, QueryEnhancerSelector selector, JpaQueryMethod queryMethod, ReturnedType returnedType) {
        if (query.isPresent() && StringUtils.hasText((String)query.getString("value"))) {
            return this.buildStringQuery(repositoryInformation.getDomainType(), returnedType, selector, query, queryMethod);
        }
        String queryName = queryMethod.getNamedQueryName();
        if (this.hasNamedQuery(queryName, returnedType)) {
            return this.buildNamedQuery(returnedType, selector, queryName, query, queryMethod);
        }
        return this.buildPartTreeQuery(returnedType, repositoryInformation, query, queryMethod);
    }

    private boolean hasNamedQuery(String queryName, ReturnedType returnedType) {
        return this.namedQueries.hasQuery(queryName) || this.getNamedQuery(returnedType, queryName) != null;
    }

    private AotQueries buildStringQuery(Class<?> domainType, final ReturnedType returnedType, QueryEnhancerSelector selector, MergedAnnotation<Query> query, JpaQueryMethod queryMethod) {
        UnaryOperator operator = s -> s.replaceAll("#\\{#entityName}", domainType.getName());
        boolean isNative = query.getBoolean("nativeQuery");
        Function<String, StringAotQuery> queryFunction = isNative ? StringAotQuery::nativeQuery : StringAotQuery::jpqlQuery;
        queryFunction = operator.andThen(queryFunction);
        String queryString = query.getString("value");
        StringAotQuery aotStringQuery = queryFunction.apply(queryString);
        String countQuery = query.getString("countQuery");
        EntityQuery entityQuery = EntityQuery.create(aotStringQuery.getQuery(), selector);
        if (entityQuery.hasConstructorExpression() || entityQuery.isDefaultProjection()) {
            aotStringQuery = aotStringQuery.withConstructorExpressionOrDefaultProjection();
        }
        if (returnedType.isProjecting() && returnedType.hasInputProperties() && !returnedType.getReturnedType().isInterface()) {
            QueryProvider rewritten = entityQuery.rewrite(new QueryEnhancer.QueryRewriteInformation(){

                @Override
                public Sort getSort() {
                    return Sort.unsorted();
                }

                @Override
                public ReturnedType getReturnedType() {
                    return returnedType;
                }
            });
            aotStringQuery = aotStringQuery.rewrite(rewritten);
        }
        if (StringUtils.hasText((String)countQuery)) {
            return AotQueries.from(aotStringQuery, queryFunction.apply(countQuery));
        }
        if (this.hasNamedQuery(queryMethod.getNamedCountQueryName(), returnedType)) {
            return AotQueries.from(aotStringQuery, this.createNamedAotQuery(returnedType, queryMethod.getNamedCountQueryName(), queryMethod, isNative));
        }
        String countProjection = query.getString("countProjection");
        return AotQueries.from(aotStringQuery, countProjection, selector);
    }

    private AotQueries buildNamedQuery(ReturnedType returnedType, QueryEnhancerSelector selector, String queryName, MergedAnnotation<Query> query, JpaQueryMethod queryMethod) {
        String countQuery;
        boolean nativeQuery = query.isPresent() && query.getBoolean("nativeQuery");
        AotQuery aotQuery = this.createNamedAotQuery(returnedType, queryName, queryMethod, nativeQuery);
        String string = countQuery = query.isPresent() ? query.getString("countQuery") : null;
        if (StringUtils.hasText((String)countQuery)) {
            return AotQueries.from(aotQuery, aotQuery.isNative() ? StringAotQuery.nativeQuery(countQuery) : StringAotQuery.jpqlQuery(countQuery));
        }
        if (this.hasNamedQuery(queryMethod.getNamedCountQueryName(), returnedType)) {
            return AotQueries.from(aotQuery, this.createNamedAotQuery(returnedType, queryMethod.getNamedCountQueryName(), queryMethod, nativeQuery));
        }
        String countProjection = query.isPresent() ? query.getString("countProjection") : null;
        return AotQueries.from(aotQuery, it -> {
            if (it instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)it;
                return sq.getQuery();
            }
            return ((NamedAotQuery)aotQuery).getQuery();
        }, countProjection, selector);
    }

    private AotQuery createNamedAotQuery(ReturnedType returnedType, String queryName, JpaQueryMethod queryMethod, boolean isNative) {
        if (this.namedQueries.hasQuery(queryName)) {
            String queryString = this.namedQueries.getQuery(queryName);
            return StringAotQuery.named(queryName, isNative ? DeclaredQuery.nativeQuery(queryString) : DeclaredQuery.jpqlQuery(queryString));
        }
        TypedQueryReference<?> namedQuery = this.getNamedQuery(returnedType, queryName);
        Assert.state((namedQuery != null ? 1 : 0) != 0, (String)"Native named query must not be null");
        return this.createNamedAotQuery(namedQuery, queryMethod, isNative);
    }

    private AotQuery createNamedAotQuery(TypedQueryReference<?> namedQuery, JpaQueryMethod queryMethod, boolean isNative) {
        QueryExtractor queryExtractor = queryMethod.getQueryExtractor();
        String queryString = queryExtractor.extractQueryString(namedQuery);
        if (!isNative) {
            isNative = queryExtractor.isNativeQuery(namedQuery);
        }
        Assert.hasText((String)queryString, () -> "Cannot extract Query from named query [%s]".formatted(namedQuery.getName()));
        return NamedAotQuery.named(namedQuery.getName(), isNative ? DeclaredQuery.nativeQuery(queryString) : DeclaredQuery.jpqlQuery(queryString));
    }

    @Nullable
    private TypedQueryReference<?> getNamedQuery(ReturnedType returnedType, String queryName) {
        List<Class> candidates = Arrays.asList(Object.class, returnedType.getDomainType(), returnedType.getReturnedType(), returnedType.getTypeToRead(), Void.TYPE, null, Long.class, Integer.class, Long.TYPE, Integer.TYPE, Number.class);
        for (Class candidate : candidates) {
            Map namedQueries = this.entityManagerFactory.getNamedQueries(candidate);
            if (!namedQueries.containsKey(queryName)) continue;
            return (TypedQueryReference)namedQueries.get(queryName);
        }
        return null;
    }

    private AotQueries buildPartTreeQuery(ReturnedType returnedType, RepositoryInformation repositoryInformation, MergedAnnotation<Query> query, JpaQueryMethod queryMethod) {
        PartTree partTree = new PartTree(queryMethod.getName(), repositoryInformation.getDomainType());
        AotQuery aotQuery = this.createQuery(partTree, returnedType, queryMethod.getParameters(), this.templates);
        if (query.isPresent() && StringUtils.hasText((String)query.getString("countQuery"))) {
            return AotQueries.from(aotQuery, StringAotQuery.jpqlQuery(query.getString("countQuery")));
        }
        if (this.hasNamedQuery(queryMethod.getNamedCountQueryName(), returnedType)) {
            return AotQueries.from(aotQuery, this.createNamedAotQuery(returnedType, queryMethod.getNamedCountQueryName(), queryMethod, false));
        }
        AotQuery partTreeCountQuery = this.createCountQuery(partTree, returnedType, queryMethod.getParameters(), this.templates);
        return AotQueries.from(aotQuery, partTreeCountQuery);
    }

    private AotQuery createQuery(PartTree partTree, ReturnedType returnedType, JpaParameters parameters, JpqlQueryTemplates templates) {
        ParameterMetadataProvider metadataProvider = new ParameterMetadataProvider(parameters, this.escapeCharacter, templates);
        JpaQueryCreator queryCreator = new JpaQueryCreator(partTree, false, returnedType, metadataProvider, templates, this.metamodel);
        return StringAotQuery.jpqlQuery((String)queryCreator.createQuery(), metadataProvider.getBindings(), partTree.getResultLimit(), partTree.isDelete(), partTree.isExistsProjection());
    }

    private AotQuery createCountQuery(PartTree partTree, ReturnedType returnedType, JpaParameters parameters, JpqlQueryTemplates templates) {
        ParameterMetadataProvider metadataProvider = new ParameterMetadataProvider(parameters, this.escapeCharacter, templates);
        JpaCountQueryCreator queryCreator = new JpaCountQueryCreator(partTree, returnedType, metadataProvider, templates, this.metamodel);
        return StringAotQuery.jpqlQuery((String)queryCreator.createQuery(), metadataProvider.getBindings(), Limit.unlimited(), false, false);
    }

    @Nullable
    public static Class<?> getQueryReturnType(AotQuery query, ReturnedType returnedType, AotQueryMethodGenerationContext context) {
        StringAotQuery sq;
        Class result;
        Method method = context.getMethod();
        RepositoryInformation repositoryInformation = context.getRepositoryInformation();
        Class methodReturnType = repositoryInformation.getReturnedDomainClass(method);
        boolean queryForEntity = repositoryInformation.getDomainType().isAssignableFrom(methodReturnType);
        Class clazz = result = queryForEntity ? returnedType.getDomainType() : null;
        if (query instanceof StringAotQuery && (sq = (StringAotQuery)query).hasConstructorExpressionOrDefaultProjection()) {
            return result;
        }
        if (returnedType.isProjecting()) {
            if (returnedType.getReturnedType().isInterface()) {
                return Tuple.class;
            }
            return returnedType.getReturnedType();
        }
        return result;
    }
}

