/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.aot;

import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import jakarta.persistence.QueryHint;
import jakarta.persistence.Tuple;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Vector;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.NativeQuery;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.aot.AotEntityGraph;
import org.springframework.data.jpa.repository.aot.AotQueries;
import org.springframework.data.jpa.repository.aot.AotQuery;
import org.springframework.data.jpa.repository.aot.NamedAotQuery;
import org.springframework.data.jpa.repository.aot.StringAotQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.javapoet.CodeBlock;
import org.springframework.javapoet.TypeName;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class JpaCodeBlocks {
    JpaCodeBlocks() {
    }

    public static QueryBlockBuilder queryBuilder(AotQueryMethodGenerationContext context, JpaQueryMethod queryMethod) {
        return new QueryBlockBuilder(context, queryMethod);
    }

    static QueryExecutionBlockBuilder executionBuilder(AotQueryMethodGenerationContext context, JpaQueryMethod queryMethod) {
        return new QueryExecutionBlockBuilder(context, queryMethod);
    }

    static class QueryBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final JpaQueryMethod queryMethod;
        private final String parameterNames;
        private String queryVariableName;
        @Nullable
        private AotQueries queries;
        private MergedAnnotation<QueryHints> queryHints = MergedAnnotation.missing();
        @Nullable
        private AotEntityGraph entityGraph;
        @Nullable
        private String sqlResultSetMapping;
        @Nullable
        private Class<?> queryReturnType;
        @Nullable
        private Class<?> queryRewriter = QueryRewriter.IdentityQueryRewriter.class;

        private QueryBlockBuilder(AotQueryMethodGenerationContext context, JpaQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
            this.queryVariableName = context.localVariable("query");
            String parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
            this.parameterNames = StringUtils.hasText((String)parameterNames) ? ", " + parameterNames : "";
        }

        public QueryBlockBuilder usingQueryVariableName(String queryVariableName) {
            this.queryVariableName = this.context.localVariable(queryVariableName);
            return this;
        }

        public QueryBlockBuilder filter(AotQueries query) {
            this.queries = query;
            return this;
        }

        public QueryBlockBuilder nativeQuery(MergedAnnotation<NativeQuery> nativeQuery) {
            if (nativeQuery.isPresent()) {
                this.sqlResultSetMapping = nativeQuery.getString("sqlResultSetMapping");
            }
            return this;
        }

        public QueryBlockBuilder queryHints(MergedAnnotation<QueryHints> queryHints) {
            this.queryHints = queryHints;
            return this;
        }

        public QueryBlockBuilder entityGraph(@Nullable AotEntityGraph entityGraph) {
            this.entityGraph = entityGraph;
            return this;
        }

        public QueryBlockBuilder queryReturnType(@Nullable Class<?> queryReturnType) {
            this.queryReturnType = queryReturnType;
            return this;
        }

        public QueryBlockBuilder queryRewriter(@Nullable Class<?> queryRewriter) {
            this.queryRewriter = queryRewriter == null ? QueryRewriter.IdentityQueryRewriter.class : queryRewriter;
            return this;
        }

        public CodeBlock build() {
            String sortParameterName;
            String pageable;
            AotQuery aotQuery;
            AotQuery aotQuery2;
            Assert.notNull((Object)this.queries, (String)"Queries must not be null");
            boolean isProjecting = this.context.getReturnedType().isProjecting();
            Class actualReturnType = isProjecting ? this.context.getActualReturnType().toClass() : this.context.getRepositoryInformation().getDomainType();
            String dynamicReturnType = null;
            if (this.queryMethod.getParameters().hasDynamicProjection()) {
                dynamicReturnType = this.context.getParameterName(this.queryMethod.getParameters().getDynamicProjectionIndex());
            }
            CodeBlock.Builder builder = CodeBlock.builder();
            String queryStringVariableName = null;
            String queryRewriterName = null;
            if (this.queries.result() instanceof StringAotQuery && this.queryRewriter != QueryRewriter.IdentityQueryRewriter.class) {
                queryRewriterName = this.context.localVariable("queryRewriter");
                builder.addStatement("$T $L = new $T()", new Object[]{this.queryRewriter, queryRewriterName, this.queryRewriter});
            }
            if ((aotQuery2 = this.queries.result()) instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)aotQuery2;
                queryStringVariableName = "%sString".formatted(this.queryVariableName);
                builder.add(this.buildQueryString(sq, queryStringVariableName));
            }
            String countQueryStringNameVariableName = null;
            String countQueryVariableName = this.context.localVariable("count%s".formatted(StringUtils.capitalize((String)this.queryVariableName)));
            if (this.queryMethod.isPageQuery() && (aotQuery = this.queries.count()) instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)aotQuery;
                countQueryStringNameVariableName = this.context.localVariable("count%sString".formatted(StringUtils.capitalize((String)this.queryVariableName)));
                builder.add(this.buildQueryString(sq, countQueryStringNameVariableName));
            }
            if ((pageable = this.context.getPageableParameterName()) != null) {
                String pageableVariableName = this.context.localVariable("pageable");
                builder.addStatement("$1T $2L = $3L != null ? $3L : $1T.unpaged()", new Object[]{Pageable.class, pageableVariableName, pageable});
                pageable = pageableVariableName;
            }
            if ((sortParameterName = this.context.getSortParameterName()) == null && pageable != null) {
                sortParameterName = "%s.getSort()".formatted(pageable);
            }
            if ((StringUtils.hasText((String)sortParameterName) || StringUtils.hasText((String)dynamicReturnType)) && this.queries != null && this.queries.result() instanceof StringAotQuery && StringUtils.hasText((String)queryStringVariableName)) {
                builder.add(this.applyRewrite(sortParameterName, dynamicReturnType, queryStringVariableName, actualReturnType));
            }
            if (this.queries.result().hasExpression() || this.queries.count().hasExpression()) {
                builder.addStatement("class ExpressionMarker{}", new Object[0]);
            }
            builder.add(this.createQuery(false, this.queryVariableName, queryStringVariableName, queryRewriterName, this.queries.result(), this.sqlResultSetMapping, pageable, this.queryHints, this.entityGraph, this.queryReturnType));
            builder.add(this.applyLimits(this.queries.result().isExists(), pageable));
            if (this.queryMethod.isPageQuery()) {
                builder.beginControlFlow("$T $L = () ->", new Object[]{LongSupplier.class, this.context.localVariable("countAll")});
                boolean queryHints = this.queryHints.isPresent() && this.queryHints.getBoolean("forCounting");
                builder.add(this.createQuery(true, countQueryVariableName, countQueryStringNameVariableName, queryRewriterName, this.queries.count(), null, pageable, queryHints ? this.queryHints : MergedAnnotation.missing(), null, Long.class));
                builder.addStatement("return ($T) $L.getSingleResult()", new Object[]{Long.class, countQueryVariableName});
                builder.unindent();
                builder.add("};\n", new Object[0]);
            }
            return builder.build();
        }

        private CodeBlock buildQueryString(StringAotQuery sq, String queryStringVariableName) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.addStatement("$T $L = $S", new Object[]{String.class, queryStringVariableName, sq.getQueryString()});
            return builder.build();
        }

        private CodeBlock applyRewrite(@Nullable String sort, @Nullable String dynamicReturnType, String queryString, Class<?> actualReturnType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean hasSort = StringUtils.hasText((String)sort);
            if (hasSort) {
                builder.beginControlFlow("if ($L.isSorted())", new Object[]{sort});
            }
            builder.addStatement("$T $L = $T.$L($L)", new Object[]{DeclaredQuery.class, this.context.localVariable("declaredQuery"), DeclaredQuery.class, this.queries != null && this.queries.isNative() ? "nativeQuery" : "jpqlQuery", queryString});
            boolean hasDynamicReturnType = StringUtils.hasText((String)dynamicReturnType);
            if (hasSort && hasDynamicReturnType) {
                builder.addStatement("$L = rewriteQuery($L, $L, $L)", new Object[]{queryString, this.context.localVariable("declaredQuery"), sort, dynamicReturnType});
            } else if (hasSort) {
                builder.addStatement("$L = rewriteQuery($L, $L, $T.class)", new Object[]{queryString, this.context.localVariable("declaredQuery"), sort, actualReturnType});
            } else if (hasDynamicReturnType) {
                builder.addStatement("$L = rewriteQuery($L, $T.unsorted(), $L)", new Object[]{this.context.localVariable("declaredQuery"), queryString, Sort.class, dynamicReturnType});
            }
            if (hasSort) {
                builder.endControlFlow();
            }
            return builder.build();
        }

        private CodeBlock applyLimits(boolean exists, String pageable) {
            CodeBlock.Builder builder = CodeBlock.builder();
            if (exists) {
                builder.addStatement("$L.setMaxResults(1)", new Object[]{this.queryVariableName});
                return builder.build();
            }
            String limit = this.context.getLimitParameterName();
            if (StringUtils.hasText((String)limit)) {
                builder.beginControlFlow("if ($L.isLimited())", new Object[]{limit});
                builder.addStatement("$L.setMaxResults($L.max())", new Object[]{this.queryVariableName, limit});
                builder.endControlFlow();
            } else if (this.queries != null && this.queries.result().isLimited()) {
                builder.addStatement("$L.setMaxResults($L)", new Object[]{this.queryVariableName, this.queries.result().getLimit().max()});
            }
            if (StringUtils.hasText((String)pageable)) {
                builder.beginControlFlow("if ($L.isPaged())", new Object[]{pageable});
                builder.addStatement("$L.setFirstResult(Long.valueOf($L.getOffset()).intValue())", new Object[]{this.queryVariableName, pageable});
                if (this.queryMethod.isSliceQuery()) {
                    builder.addStatement("$L.setMaxResults($L.getPageSize() + 1)", new Object[]{this.queryVariableName, pageable});
                } else {
                    builder.addStatement("$L.setMaxResults($L.getPageSize())", new Object[]{this.queryVariableName, pageable});
                }
                builder.endControlFlow();
            }
            return builder.build();
        }

        private CodeBlock createQuery(boolean count, String queryVariableName, @Nullable String queryStringNameVariableName, @Nullable String queryRewriterName, AotQuery query, @Nullable String sqlResultSetMapping, @Nullable String pageable, MergedAnnotation<QueryHints> queryHints, @Nullable AotEntityGraph entityGraph, @Nullable Class<?> queryReturnType) {
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add(this.doCreateQuery(count, queryVariableName, queryStringNameVariableName, queryRewriterName, query, sqlResultSetMapping, pageable, queryReturnType));
            if (entityGraph != null) {
                builder.add(this.applyEntityGraph(entityGraph, queryVariableName));
            }
            if (queryHints.isPresent()) {
                builder.add(this.applyHints(queryVariableName, queryHints));
                builder.add("\n", new Object[0]);
            }
            for (ParameterBinding binding : query.getParameterBindings()) {
                String prepared;
                String parameterName;
                MethodParameter methodParameter;
                Object prepare = binding.prepare("s");
                Object parameterIdentifier = this.getParameterName(binding.getIdentifier());
                String valueFormat = parameterIdentifier instanceof CharSequence ? "$S" : "$L";
                Object parameter = this.getParameter(binding.getOrigin());
                if (parameter instanceof String && (methodParameter = this.context.getMethodParameter(parameterName = (String)parameter)) != null) {
                    parameter = this.postProcessBindingValue(binding, methodParameter, parameterName);
                }
                if (prepare instanceof String && !(prepared = (String)prepare).equals("s")) {
                    String format = prepared.replaceAll("%", "%%").replace("s", "%s");
                    builder.addStatement("$L.setParameter(%s, $S.formatted($L))".formatted(valueFormat), new Object[]{queryVariableName, parameterIdentifier, format, parameter});
                    continue;
                }
                builder.addStatement("$L.setParameter(%s, $L)".formatted(valueFormat), new Object[]{queryVariableName, parameterIdentifier, parameter});
            }
            return builder.build();
        }

        private Object postProcessBindingValue(ParameterBinding binding, MethodParameter methodParameter, String parameterName) {
            ParameterBinding.PartTreeParameterBinding treeBinding;
            Class parameterType = methodParameter.getParameterType();
            if (Score.class.isAssignableFrom(parameterType)) {
                return parameterName + ".getValue()";
            }
            if (Vector.class.isAssignableFrom(parameterType)) {
                return "%1$s.getType() == Float.TYPE ? %1$s.toFloatArray() : %1$s.toDoubleArray()".formatted(parameterName);
            }
            if (binding instanceof ParameterBinding.PartTreeParameterBinding && (treeBinding = (ParameterBinding.PartTreeParameterBinding)binding).isIgnoreCase()) {
                String function;
                String string = function = treeBinding.getTemplates() == JpqlQueryTemplates.LOWER ? "toLowerCase" : "toUpperCase";
                if (QueryBlockBuilder.isArray(parameterType) || Collection.class.isAssignableFrom(parameterType)) {
                    return CodeBlock.builder().add("mapIgnoreCase($L, $T::$L)", new Object[]{parameterName, String.class, function}).build();
                }
                if (String.class.isAssignableFrom(parameterType)) {
                    return "%1$s != null ? %1$s.%2$s() : %1$s".formatted(parameterName, function);
                }
                return "%1$s != null ? %1$s.toString().%2$s() : %1$s".formatted(parameterName, function);
            }
            if (QueryBlockBuilder.isArray(parameterType)) {
                return CodeBlock.builder().add("$T.asList($L)", new Object[]{Arrays.class, parameterName}).build();
            }
            return parameterName;
        }

        private static boolean isArray(Class<?> parameterType) {
            return parameterType.isArray() && !parameterType.getComponentType().equals(Byte.TYPE) && !parameterType.getComponentType().equals(Byte.class);
        }

        private CodeBlock doCreateQuery(boolean count, String queryVariableName, @Nullable String queryStringName, @Nullable String queryRewriterName, AotQuery query, @Nullable String sqlResultSetMapping, @Nullable String pageable, @Nullable Class<?> queryReturnType) {
            ReturnedType returnedType = this.context.getReturnedType();
            CodeBlock.Builder builder = CodeBlock.builder();
            Object queryStringNameToUse = queryStringName;
            if (query instanceof StringAotQuery) {
                StringAotQuery sq = (StringAotQuery)query;
                if (StringUtils.hasText((String)queryRewriterName)) {
                    queryStringNameToUse = queryStringName + "Rewritten";
                    if (StringUtils.hasText((String)pageable)) {
                        builder.addStatement("$T $L = $L.rewrite($L, $L)", new Object[]{String.class, queryStringNameToUse, queryRewriterName, queryStringName, pageable});
                    } else if (StringUtils.hasText((String)this.context.getSortParameterName())) {
                        builder.addStatement("$T $L = $L.rewrite($L, $L)", new Object[]{String.class, queryStringNameToUse, queryRewriterName, queryStringName, this.context.getSortParameterName()});
                    } else {
                        builder.addStatement("$T $L = $L.rewrite($L, $T.unsorted())", new Object[]{String.class, queryStringNameToUse, queryRewriterName, queryStringName, Sort.class});
                    }
                }
                if (StringUtils.hasText((String)sqlResultSetMapping)) {
                    builder.addStatement("$T $L = this.$L.createNativeQuery($L, $S)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), queryStringNameToUse, sqlResultSetMapping});
                    return builder.build();
                }
                if (query.isNative()) {
                    if (queryReturnType != null) {
                        builder.addStatement("$T $L = this.$L.createNativeQuery($L, $T.class)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), queryStringNameToUse, queryReturnType});
                    } else {
                        builder.addStatement("$T $L = this.$L.createNativeQuery($L)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), queryStringNameToUse});
                    }
                    return builder.build();
                }
                if (sq.hasConstructorExpressionOrDefaultProjection() && !count && returnedType.isProjecting() && returnedType.getReturnedType().isInterface()) {
                    builder.addStatement("$T $L = this.$L.createQuery($L)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), queryStringNameToUse});
                } else {
                    String createQueryMethod;
                    String string = createQueryMethod = query.isNative() ? "createNativeQuery" : "createQuery";
                    if (!sq.hasConstructorExpressionOrDefaultProjection() && !count && returnedType.isProjecting() && returnedType.getReturnedType().isInterface()) {
                        builder.addStatement("$T $L = this.$L.$L($L, $T.class)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), createQueryMethod, queryStringNameToUse, Tuple.class});
                    } else {
                        builder.addStatement("$T $L = this.$L.$L($L)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), createQueryMethod, queryStringNameToUse});
                    }
                }
                return builder.build();
            }
            if (query instanceof NamedAotQuery) {
                NamedAotQuery nq = (NamedAotQuery)query;
                if (!count && returnedType.isProjecting() && returnedType.getReturnedType().isInterface()) {
                    builder.addStatement("$T $L = this.$L.createNamedQuery($S)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), nq.getName()});
                    return builder.build();
                }
                if (queryReturnType != null) {
                    builder.addStatement("$T $L = this.$L.createNamedQuery($S, $T.class)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), nq.getName(), queryReturnType});
                    return builder.build();
                }
                builder.addStatement("$T $L = this.$L.createNamedQuery($S)", new Object[]{Query.class, queryVariableName, this.context.fieldNameOf(EntityManager.class), nq.getName()});
                return builder.build();
            }
            throw new UnsupportedOperationException("Unsupported query type: " + String.valueOf(query));
        }

        private Object getParameterName(ParameterBinding.BindingIdentifier identifier) {
            return identifier.hasName() ? identifier.getName() : Integer.valueOf(identifier.getPosition());
        }

        private Object getParameter(ParameterBinding.ParameterOrigin origin) {
            if (origin.isMethodArgument() && origin instanceof ParameterBinding.MethodInvocationArgument) {
                ParameterBinding.MethodInvocationArgument mia = (ParameterBinding.MethodInvocationArgument)origin;
                if (mia.identifier().hasPosition()) {
                    return this.context.getRequiredBindableParameterName(mia.identifier().getPosition() - 1);
                }
                if (mia.identifier().hasName()) {
                    return this.context.getRequiredBindableParameterName(mia.identifier().getName());
                }
            }
            if (origin.isExpression() && origin instanceof ParameterBinding.Expression) {
                ParameterBinding.Expression expr = (ParameterBinding.Expression)origin;
                CodeBlock.Builder builder = CodeBlock.builder();
                Object expressionString = expr.expression().getExpressionString();
                if (!((String)expressionString).startsWith("$")) {
                    expressionString = "#{" + (String)expressionString + "}";
                }
                builder.add("evaluateExpression(ExpressionMarker.class.getEnclosingMethod(), $S$L)", new Object[]{expressionString, this.parameterNames});
                return builder.build();
            }
            throw new UnsupportedOperationException("Not supported yet");
        }

        private CodeBlock applyEntityGraph(AotEntityGraph entityGraph, String queryVariableName) {
            CodeBlock.Builder builder = CodeBlock.builder();
            if (StringUtils.hasText((String)entityGraph.name())) {
                builder.addStatement("$T<?> $L = $L.getEntityGraph($S)", new Object[]{EntityGraph.class, this.context.localVariable("entityGraph"), this.context.fieldNameOf(EntityManager.class), entityGraph.name()});
            } else {
                builder.addStatement("$T<$T> $L = $L.createEntityGraph($T.class)", new Object[]{EntityGraph.class, this.context.getActualReturnType().getType(), this.context.localVariable("entityGraph"), this.context.fieldNameOf(EntityManager.class), this.context.getActualReturnType().getType()});
                for (String attributePath : entityGraph.attributePaths()) {
                    Object[] pathComponents = StringUtils.delimitedListToStringArray((String)attributePath, (String)".");
                    StringBuilder chain = new StringBuilder(this.context.localVariable("entityGraph"));
                    int i = 0;
                    while (i < pathComponents.length) {
                        if (i < pathComponents.length - 1) {
                            chain.append(".addSubgraph($S)");
                        } else {
                            chain.append(".addAttributeNodes($S)");
                        }
                        ++i;
                    }
                    builder.addStatement(chain.toString(), pathComponents);
                }
                builder.addStatement("$L.setHint($S, $L)", new Object[]{queryVariableName, entityGraph.type().getKey(), this.context.localVariable("entityGraph")});
            }
            return builder.build();
        }

        private CodeBlock applyHints(String queryVariableName, MergedAnnotation<QueryHints> queryHints) {
            MergedAnnotation[] values;
            CodeBlock.Builder hintsBuilder = CodeBlock.builder();
            MergedAnnotation[] mergedAnnotationArray = values = queryHints.getAnnotationArray("value", QueryHint.class);
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                MergedAnnotation hint = mergedAnnotationArray[n2];
                hintsBuilder.addStatement("$L.setHint($S, $S)", new Object[]{queryVariableName, hint.getString("name"), hint.getString("value")});
                ++n2;
            }
            return hintsBuilder.build();
        }
    }

    static class QueryExecutionBlockBuilder {
        private final AotQueryMethodGenerationContext context;
        private final JpaQueryMethod queryMethod;
        @Nullable
        private AotQuery aotQuery;
        private String queryVariableName;
        @Nullable
        private String pageable;
        private MergedAnnotation<Modifying> modifying = MergedAnnotation.missing();

        private QueryExecutionBlockBuilder(AotQueryMethodGenerationContext context, JpaQueryMethod queryMethod) {
            this.context = context;
            this.queryMethod = queryMethod;
            this.queryVariableName = context.localVariable("query");
            this.pageable = context.getPageableParameterName() != null ? context.localVariable("pageable") : null;
        }

        public QueryExecutionBlockBuilder referencing(String queryVariableName) {
            this.queryVariableName = this.context.localVariable(queryVariableName);
            return this;
        }

        public QueryExecutionBlockBuilder query(AotQuery aotQuery) {
            this.aotQuery = aotQuery;
            return this;
        }

        public QueryExecutionBlockBuilder query(String pageable) {
            this.pageable = pageable;
            return this;
        }

        public QueryExecutionBlockBuilder modifying(MergedAnnotation<Modifying> modifying) {
            this.modifying = modifying;
            return this;
        }

        public CodeBlock build() {
            CodeBlock.Builder builder = CodeBlock.builder();
            boolean isProjecting = this.context.getActualReturnType() != null && !ObjectUtils.nullSafeEquals((Object)TypeName.get((Type)this.context.getRepositoryInformation().getDomainType()), (Object)this.context.getActualReturnType());
            Type actualReturnType = isProjecting ? this.context.getActualReturnType().getType() : this.context.getRepositoryInformation().getDomainType();
            builder.add("\n", new Object[0]);
            if (this.modifying.isPresent()) {
                Class<?> returnType;
                if (this.modifying.getBoolean("flushAutomatically")) {
                    builder.addStatement("this.$L.flush()", new Object[]{this.context.fieldNameOf(EntityManager.class)});
                }
                if (QueryExecutionBlockBuilder.returnsModifying(returnType = this.context.getMethod().getReturnType())) {
                    builder.addStatement("int $L = $L.executeUpdate()", new Object[]{this.context.localVariable("result"), this.queryVariableName});
                } else {
                    builder.addStatement("$L.executeUpdate()", new Object[]{this.queryVariableName});
                }
                if (this.modifying.getBoolean("clearAutomatically")) {
                    builder.addStatement("this.$L.clear()", new Object[]{this.context.fieldNameOf(EntityManager.class)});
                }
                if (returnType == Integer.TYPE || returnType == Long.TYPE || returnType == Integer.class) {
                    builder.addStatement("return $L", new Object[]{this.context.localVariable("result")});
                }
                if (returnType == Long.class) {
                    builder.addStatement("return (long) $L", new Object[]{this.context.localVariable("result")});
                }
                return builder.build();
            }
            TypeName queryResultType = TypeName.get((Type)this.context.getActualReturnType().toClass());
            if (this.aotQuery != null && this.aotQuery.isDelete()) {
                builder.addStatement("$T $L = $L.getResultList()", new Object[]{List.class, this.context.localVariable("resultList"), this.queryVariableName});
                builder.addStatement("$L.forEach($L::remove)", new Object[]{this.context.localVariable("resultList"), this.context.fieldNameOf(EntityManager.class)});
                if (!Collection.class.isAssignableFrom(this.context.getReturnType().toClass())) {
                    if (ClassUtils.isAssignable(Number.class, this.context.getMethod().getReturnType())) {
                        builder.addStatement("return $T.valueOf($L.size())", new Object[]{this.context.getMethod().getReturnType(), this.context.localVariable("resultList")});
                    } else {
                        builder.addStatement("return ($T) ($L.isEmpty() ? null : $L.iterator().next())", new Object[]{actualReturnType, this.context.localVariable("resultList"), this.context.localVariable("resultList")});
                    }
                } else {
                    builder.addStatement("return ($T) $L", new Object[]{List.class, this.context.localVariable("resultList")});
                }
            } else if (this.aotQuery != null && this.aotQuery.isExists()) {
                builder.addStatement("return !$L.getResultList().isEmpty()", new Object[]{this.queryVariableName});
            } else if (this.aotQuery != null) {
                if (this.context.getReturnedType().isProjecting()) {
                    if (this.queryMethod.isCollectionQuery()) {
                        builder.addStatement("return ($T) convertMany($L.getResultList(), $L, $T.class)", new Object[]{this.context.getReturnTypeName(), this.queryVariableName, this.aotQuery.isNative(), queryResultType});
                    } else if (this.queryMethod.isStreamQuery()) {
                        builder.addStatement("return ($T) convertMany($L.getResultStream(), $L, $T.class)", new Object[]{this.context.getReturnTypeName(), this.queryVariableName, this.aotQuery.isNative(), queryResultType});
                    } else if (this.queryMethod.isPageQuery()) {
                        builder.addStatement("return $T.getPage(($T<$T>) convertMany($L.getResultList(), $L, $T.class), $L, $L)", new Object[]{PageableExecutionUtils.class, List.class, actualReturnType, this.queryVariableName, this.aotQuery.isNative(), queryResultType, this.pageable, this.context.localVariable("countAll")});
                    } else if (this.queryMethod.isSliceQuery()) {
                        builder.addStatement("$T<$T> $L = ($T<$T>) convertMany($L.getResultList(), $L, $T.class)", new Object[]{List.class, actualReturnType, this.context.localVariable("resultList"), List.class, actualReturnType, this.queryVariableName, this.aotQuery.isNative(), queryResultType});
                        builder.addStatement("boolean $L = $L.isPaged() && $L.size() > $L.getPageSize()", new Object[]{this.context.localVariable("hasNext"), this.pageable, this.context.localVariable("resultList"), this.pageable});
                        builder.addStatement("return new $T<>($L ? $L.subList(0, $L.getPageSize()) : $L, $L, $L)", new Object[]{SliceImpl.class, this.context.localVariable("hasNext"), this.context.localVariable("resultList"), this.pageable, this.context.localVariable("resultList"), this.pageable, this.context.localVariable("hasNext")});
                    } else if (Optional.class.isAssignableFrom(this.context.getReturnType().toClass())) {
                        builder.addStatement("return $T.ofNullable(($T) convertOne($L.getSingleResultOrNull(), $L, $T.class))", new Object[]{Optional.class, actualReturnType, this.queryVariableName, this.aotQuery.isNative(), queryResultType});
                    } else {
                        builder.addStatement("return ($T) convertOne($L.getSingleResultOrNull(), $L, $T.class)", new Object[]{this.context.getReturnTypeName(), this.queryVariableName, this.aotQuery.isNative(), queryResultType});
                    }
                } else if (this.queryMethod.isCollectionQuery()) {
                    builder.addStatement("return ($T) $L.getResultList()", new Object[]{this.context.getReturnTypeName(), this.queryVariableName});
                } else if (this.queryMethod.isStreamQuery()) {
                    builder.addStatement("return ($T) $L.getResultStream()", new Object[]{this.context.getReturnTypeName(), this.queryVariableName});
                } else if (this.queryMethod.isPageQuery()) {
                    builder.addStatement("return $T.getPage(($T<$T>) $L.getResultList(), $L, $L)", new Object[]{PageableExecutionUtils.class, List.class, actualReturnType, this.queryVariableName, this.pageable, this.context.localVariable("countAll")});
                } else if (this.queryMethod.isSliceQuery()) {
                    builder.addStatement("$T<$T> $L = $L.getResultList()", new Object[]{List.class, actualReturnType, this.context.localVariable("resultList"), this.queryVariableName});
                    builder.addStatement("boolean $L = $L.isPaged() && $L.size() > $L.getPageSize()", new Object[]{this.context.localVariable("hasNext"), this.pageable, this.context.localVariable("resultList"), this.pageable});
                    builder.addStatement("return new $T<>($L ? $L.subList(0, $L.getPageSize()) : $L, $L, $L)", new Object[]{SliceImpl.class, this.context.localVariable("hasNext"), this.context.localVariable("resultList"), this.pageable, this.context.localVariable("resultList"), this.pageable, this.context.localVariable("hasNext")});
                } else if (Optional.class.isAssignableFrom(this.context.getReturnType().toClass())) {
                    builder.addStatement("return $T.ofNullable(($T) convertOne($L.getSingleResultOrNull(), $L, $T.class))", new Object[]{Optional.class, actualReturnType, this.queryVariableName, this.aotQuery.isNative(), this.context.getActualReturnType().toClass()});
                } else {
                    builder.addStatement("return ($T) convertOne($L.getSingleResultOrNull(), $L, $T.class)", new Object[]{this.context.getReturnTypeName(), this.queryVariableName, this.aotQuery.isNative(), this.context.getReturnType().toClass()});
                }
            }
            return builder.build();
        }

        public static boolean returnsModifying(Class<?> returnType) {
            return returnType == Integer.TYPE || returnType == Long.TYPE || returnType == Integer.class || returnType == Long.class;
        }
    }
}

