/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaRepositoryFragmentsContributor;
import org.springframework.data.jpa.repository.support.QuerydslJpaPredicateExecutor;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;

enum QuerydslContributor implements JpaRepositoryFragmentsContributor
{
    INSTANCE;


    @Override
    public RepositoryComposition.RepositoryFragments contribute(RepositoryMetadata metadata, JpaEntityInformation<?, ?> entityInformation, EntityManager entityManager, EntityPathResolver resolver) {
        if (QuerydslContributor.isQuerydslRepository(metadata)) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            QuerydslJpaPredicateExecutor executor = new QuerydslJpaPredicateExecutor(entityInformation, entityManager, resolver, null);
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.implemented(QuerydslPredicateExecutor.class, executor)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    public RepositoryComposition.RepositoryFragments describe(RepositoryMetadata metadata) {
        if (QuerydslContributor.isQuerydslRepository(metadata)) {
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.structural(QuerydslPredicateExecutor.class, QuerydslJpaPredicateExecutor.class)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private static boolean isQuerydslRepository(RepositoryMetadata metadata) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
    }
}

