/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import jakarta.persistence.EntityManager;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.stream.Stream;
import org.aopalliance.aop.Advice;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.jpa.projection.CollectionAwareProjectionFactory;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.BeanFactoryQueryRewriterProvider;
import org.springframework.data.jpa.repository.query.DefaultJpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaQueryConfiguration;
import org.springframework.data.jpa.repository.query.JpaQueryLookupStrategy;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.JpaQueryMethodFactory;
import org.springframework.data.jpa.repository.query.Procedure;
import org.springframework.data.jpa.repository.query.QueryEnhancerSelector;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.jpa.repository.support.CrudMethodMetadata;
import org.springframework.data.jpa.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.JpaRepositoryConfigurationAware;
import org.springframework.data.jpa.repository.support.JpaRepositoryImplementation;
import org.springframework.data.jpa.repository.support.QuerydslJpaPredicateExecutor;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.data.jpa.util.JpaMetamodel;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.querydsl.SimpleEntityPathResolver;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.QueryCreationListener;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.SurroundingTransactionDetectorMethodInterceptor;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class JpaRepositoryFactory
extends RepositoryFactorySupport {
    private final EntityManager entityManager;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;
    private final CrudMethodMetadata crudMethodMetadata;
    private EntityPathResolver entityPathResolver;
    private EscapeCharacter escapeCharacter = EscapeCharacter.DEFAULT;
    private QueryEnhancerSelector queryEnhancerSelector = QueryEnhancerSelector.DEFAULT_SELECTOR;
    private JpaQueryMethodFactory queryMethodFactory;
    private QueryRewriterProvider queryRewriterProvider;

    public JpaRepositoryFactory(EntityManager entityManager) {
        Assert.notNull((Object)entityManager, (String)"EntityManager must not be null");
        this.entityManager = entityManager;
        PersistenceProvider extractor = PersistenceProvider.fromEntityManager(entityManager);
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.entityPathResolver = SimpleEntityPathResolver.INSTANCE;
        this.queryMethodFactory = new DefaultJpaQueryMethodFactory(extractor);
        this.queryRewriterProvider = QueryRewriterProvider.simple();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
        this.addRepositoryProxyPostProcessor((factory, repositoryInformation) -> {
            if (JpaRepositoryFactory.isTransactionNeeded(repositoryInformation.getRepositoryInterface())) {
                factory.addAdvice((Advice)SurroundingTransactionDetectorMethodInterceptor.INSTANCE);
            }
        });
        if (extractor.equals(PersistenceProvider.ECLIPSELINK)) {
            this.addQueryCreationListener(new EclipseLinkProjectionQueryCreationListener(entityManager));
        }
        this.crudMethodMetadata = this.crudMethodMetadataPostProcessor.getCrudMethodMetadata();
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        super.setBeanFactory(beanFactory);
        Assert.notNull((Object)beanFactory, (String)"BeanFactory must not be null");
        this.setQueryRewriterProvider(new BeanFactoryQueryRewriterProvider(beanFactory));
    }

    public void setEntityPathResolver(EntityPathResolver entityPathResolver) {
        Assert.notNull((Object)entityPathResolver, (String)"EntityPathResolver must not be null");
        this.entityPathResolver = entityPathResolver;
    }

    public void setEscapeCharacter(EscapeCharacter escapeCharacter) {
        this.escapeCharacter = escapeCharacter;
    }

    public void setQueryMethodFactory(JpaQueryMethodFactory queryMethodFactory) {
        Assert.notNull((Object)queryMethodFactory, (String)"QueryMethodFactory must not be null");
        this.queryMethodFactory = queryMethodFactory;
    }

    public void setQueryEnhancerSelector(QueryEnhancerSelector queryEnhancerSelector) {
        Assert.notNull((Object)queryEnhancerSelector, (String)"QueryEnhancerSelector must not be null");
        this.queryEnhancerSelector = queryEnhancerSelector;
    }

    public void setQueryRewriterProvider(QueryRewriterProvider queryRewriterProvider) {
        Assert.notNull((Object)queryRewriterProvider, (String)"QueryRewriterProvider must not be null");
        this.queryRewriterProvider = queryRewriterProvider;
    }

    protected final JpaRepositoryImplementation<?, ?> getTargetRepository(RepositoryInformation information) {
        JpaRepositoryImplementation<?, ?> repository = this.getTargetRepository(information, this.entityManager);
        this.invokeAwareMethods(repository);
        return repository;
    }

    protected JpaRepositoryImplementation<?, ?> getTargetRepository(RepositoryInformation information, EntityManager entityManager) {
        EntityInformation entityInformation = this.getEntityInformation(information.getDomainType());
        Object repository = this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, entityManager});
        Assert.isInstanceOf(JpaRepositoryImplementation.class, (Object)repository);
        return (JpaRepositoryImplementation)repository;
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleJpaRepository.class;
    }

    protected ProjectionFactory getProjectionFactory(@Nullable ClassLoader classLoader, @Nullable BeanFactory beanFactory) {
        CollectionAwareProjectionFactory factory = new CollectionAwareProjectionFactory();
        if (classLoader != null) {
            factory.setBeanClassLoader(classLoader);
        }
        if (beanFactory != null) {
            factory.setBeanFactory(beanFactory);
        }
        return factory;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        JpaQueryConfiguration queryConfiguration = new JpaQueryConfiguration(this.queryRewriterProvider, this.queryEnhancerSelector, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate), this.escapeCharacter);
        return Optional.of(JpaQueryLookupStrategy.create(this.entityManager, this.queryMethodFactory, key, queryConfiguration));
    }

    public <T, ID> JpaEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        return JpaEntityInformationSupport.getEntityInformation(domainClass, this.entityManager);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.entityManager, this.entityPathResolver, this.crudMethodMetadata);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, EntityManager entityManager, EntityPathResolver resolver, CrudMethodMetadata crudMethodMetadata) {
        boolean isQueryDslRepository;
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            QuerydslJpaPredicateExecutor querydslJpaPredicateExecutor = new QuerydslJpaPredicateExecutor(this.getEntityInformation(metadata.getDomainType()), entityManager, resolver, crudMethodMetadata);
            this.invokeAwareMethods(querydslJpaPredicateExecutor);
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.implemented(QuerydslPredicateExecutor.class, querydslJpaPredicateExecutor)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private void invokeAwareMethods(JpaRepositoryConfigurationAware repository) {
        repository.setRepositoryMethodMetadata(this.crudMethodMetadata);
        repository.setEscapeCharacter(this.escapeCharacter);
        repository.setProjectionFactory(this.getProjectionFactory());
    }

    private static boolean isTransactionNeeded(Class<?> repositoryClass) {
        Method[] methods;
        Method[] methodArray = methods = ReflectionUtils.getAllDeclaredMethods(repositoryClass);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (Stream.class.isAssignableFrom(method.getReturnType()) || method.isAnnotationPresent(Procedure.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class EclipseLinkProjectionQueryCreationListener
    implements QueryCreationListener<AbstractJpaQuery> {
        private static final String ECLIPSELINK_PROJECTIONS = "Usage of Spring Data projections detected on persistence provider EclipseLink; Make sure the following query methods declare result columns in exactly the order the accessors are declared in the projecting interface or the order of parameters for DTOs:";
        private static final Log log = LogFactory.getLog(EclipseLinkProjectionQueryCreationListener.class);
        private final JpaMetamodel metamodel;
        private boolean warningLogged = false;

        public EclipseLinkProjectionQueryCreationListener(EntityManager em) {
            Assert.notNull((Object)em, (String)"EntityManager must not be null");
            this.metamodel = JpaMetamodel.of(em.getMetamodel());
        }

        public void onCreation(AbstractJpaQuery query) {
            JpaQueryMethod queryMethod = query.getQueryMethod();
            ReturnedType type = queryMethod.getResultProcessor().getReturnedType();
            if (type.isProjecting() && !this.metamodel.isJpaManaged(type.getReturnedType())) {
                if (!this.warningLogged) {
                    log.info((Object)ECLIPSELINK_PROJECTIONS);
                    this.warningLogged = true;
                }
                log.info((Object)String.format(" - %s", new Object[]{queryMethod}));
            }
        }
    }
}

