/*
 * Copyright 2019-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Method;

import org.springframework.data.jpa.provider.QueryExtractor;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.util.Assert;

/**
 * A factory for creating {@link JpaQueryMethod} instances.
 *
 * @author Jens Schauder
 * @since 2.3
 */
public class DefaultJpaQueryMethodFactory implements JpaQueryMethodFactory {

	private final QueryExtractor extractor;

	public DefaultJpaQueryMethodFactory(QueryExtractor extractor) {

		Assert.notNull(extractor, "QueryExtractor must not be null");

		this.extractor = extractor;
	}

	@Override
	public JpaQueryMethod build(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
		return new JpaQueryMethod(method, metadata, factory, extractor);
	}
}
