/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.EntityManager;
import jakarta.persistence.Query;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.expression.ValueEvaluationContextProvider;
import org.springframework.data.expression.ValueExpressionParser;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.DefaultQueryRewriteInformation;
import org.springframework.data.jpa.repository.query.ExpressionBasedStringQuery;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.jpa.repository.query.ParameterBinderFactory;
import org.springframework.data.jpa.repository.query.QueryEnhancerFactory;
import org.springframework.data.jpa.repository.query.QueryParameterSetter;
import org.springframework.data.jpa.repository.query.StringQuery;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentLruCache;
import org.springframework.util.StringUtils;

abstract class AbstractStringBasedJpaQuery
extends AbstractJpaQuery {
    private final StringQuery query;
    private final Map<Class<?>, Boolean> knownProjections = new ConcurrentHashMap();
    private final Lazy<DeclaredQuery> countQuery;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final QueryParameterSetter.QueryMetadataCache metadataCache = new QueryParameterSetter.QueryMetadataCache();
    private final QueryRewriter queryRewriter;
    private final QuerySortRewriter querySortRewriter;
    private final Lazy<ParameterBinder> countParameterBinder;
    private final ValueEvaluationContextProvider valueExpressionContextProvider;

    public AbstractStringBasedJpaQuery(JpaQueryMethod method, EntityManager em, String queryString, @Nullable String countQueryString, QueryRewriter queryRewriter, ValueExpressionDelegate valueExpressionDelegate) {
        super(method, em);
        Assert.hasText((String)queryString, (String)"Query string must not be null or empty");
        Assert.notNull((Object)valueExpressionDelegate, (String)"ValueExpressionDelegate must not be null");
        Assert.notNull((Object)queryRewriter, (String)"QueryRewriter must not be null");
        this.valueExpressionDelegate = valueExpressionDelegate;
        this.valueExpressionContextProvider = valueExpressionDelegate.createValueContextProvider((Parameters)method.getParameters());
        this.query = new ExpressionBasedStringQuery(queryString, method, (ValueExpressionParser)valueExpressionDelegate);
        this.countQuery = Lazy.of(() -> {
            if (StringUtils.hasText((String)countQueryString)) {
                return new ExpressionBasedStringQuery(countQueryString, method, (ValueExpressionParser)valueExpressionDelegate);
            }
            return this.query.deriveCountQuery(method.getCountQueryProjection());
        });
        this.countParameterBinder = Lazy.of(() -> this.createBinder((DeclaredQuery)this.countQuery.get()));
        this.queryRewriter = queryRewriter;
        JpaParameters parameters = method.getParameters();
        this.querySortRewriter = parameters.hasDynamicProjection() ? SimpleQuerySortRewriter.INSTANCE : (parameters.hasPageableParameter() || parameters.hasSortParameter() ? new CachingQuerySortRewriter() : new UnsortedCachingQuerySortRewriter());
        Assert.isTrue((method.isNativeQuery() || !this.query.usesJdbcStyleParameters() ? 1 : 0) != 0, (String)"JDBC style parameters (?) are not supported for JPA queries");
    }

    @Override
    public Query doCreateQuery(JpaParametersParameterAccessor accessor) {
        Sort sort = accessor.getSort();
        ResultProcessor processor = this.getQueryMethod().getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        ReturnedType returnedType = this.getReturnedType(processor);
        String sortedQueryString = this.getSortedQueryString(sort, returnedType);
        Query query = this.createJpaQuery(sortedQueryString, sort, accessor.getPageable(), returnedType);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(sortedQueryString, query);
        return ((ParameterBinder)this.parameterBinder.get()).bindAndPrepare(query, metadata, accessor);
    }

    ReturnedType getReturnedType(ResultProcessor processor) {
        ReturnedType returnedType = processor.getReturnedType();
        Class returnedJavaType = returnedType.getReturnedType();
        if (this.query.hasConstructorExpression() || !returnedType.isProjecting() || returnedJavaType.isInterface() || this.query.isNativeQuery()) {
            return returnedType;
        }
        Boolean known = this.knownProjections.get(returnedJavaType);
        if (known != null && known.booleanValue()) {
            return returnedType;
        }
        if (known != null && !known.booleanValue() || returnedJavaType.isArray() || this.getMetamodel().isJpaManaged(returnedJavaType) || !returnedType.needsCustomConstruction()) {
            if (known == null) {
                this.knownProjections.put(returnedJavaType, false);
            }
            return new NonProjectingReturnedType(returnedType);
        }
        this.knownProjections.put(returnedJavaType, true);
        return returnedType;
    }

    String getSortedQueryString(Sort sort, ReturnedType returnedType) {
        return this.querySortRewriter.getSorted(this.query, sort, returnedType);
    }

    @Override
    protected ParameterBinder createBinder() {
        return this.createBinder(this.query);
    }

    protected ParameterBinder createBinder(DeclaredQuery query) {
        return ParameterBinderFactory.createQueryAwareBinder(this.getQueryMethod().getParameters(), query, (ValueExpressionParser)this.valueExpressionDelegate, this.valueExpressionContextProvider);
    }

    @Override
    protected Query doCreateCountQuery(JpaParametersParameterAccessor accessor) {
        String queryString = ((DeclaredQuery)this.countQuery.get()).getQueryString();
        EntityManager em = this.getEntityManager();
        String queryStringToUse = this.potentiallyRewriteQuery(queryString, accessor.getSort(), accessor.getPageable());
        Query query = this.getQueryMethod().isNativeQuery() ? em.createNativeQuery(queryStringToUse) : em.createQuery(queryStringToUse, Long.class);
        QueryParameterSetter.QueryMetadata metadata = this.metadataCache.getMetadata(queryString, query);
        ((ParameterBinder)this.countParameterBinder.get()).bind(metadata.withQuery(query), accessor, QueryParameterSetter.ErrorHandling.LENIENT);
        return query;
    }

    public DeclaredQuery getQuery() {
        return this.query;
    }

    public DeclaredQuery getCountQuery() {
        return (DeclaredQuery)this.countQuery.get();
    }

    protected Query createJpaQuery(String queryString, Sort sort, @Nullable Pageable pageable, ReturnedType returnedType) {
        EntityManager em = this.getEntityManager();
        String queryToUse = this.potentiallyRewriteQuery(queryString, sort, pageable);
        if (this.query.hasConstructorExpression() || this.query.isDefaultProjection()) {
            return em.createQuery(queryToUse);
        }
        Class<?> typeToRead = this.getTypeToRead(returnedType);
        return typeToRead == null ? em.createQuery(queryToUse) : em.createQuery(queryToUse, typeToRead);
    }

    protected String potentiallyRewriteQuery(String originalQuery, Sort sort, @Nullable Pageable pageable) {
        return pageable != null && pageable.isPaged() ? this.queryRewriter.rewrite(originalQuery, pageable) : this.queryRewriter.rewrite(originalQuery, sort);
    }

    String applySorting(CachableQuery cachableQuery) {
        return QueryEnhancerFactory.forQuery(cachableQuery.getDeclaredQuery()).rewrite(new DefaultQueryRewriteInformation(cachableQuery.getSort(), cachableQuery.getReturnedType()));
    }

    static class CachableQuery {
        private final DeclaredQuery declaredQuery;
        private final String queryString;
        private final Sort sort;
        private final ReturnedType returnedType;

        CachableQuery(DeclaredQuery query, Sort sort, ReturnedType returnedType) {
            this.declaredQuery = query;
            this.queryString = query.getQueryString();
            this.sort = sort;
            this.returnedType = returnedType;
        }

        DeclaredQuery getDeclaredQuery() {
            return this.declaredQuery;
        }

        Sort getSort() {
            return this.sort;
        }

        public ReturnedType getReturnedType() {
            return this.returnedType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CachableQuery that = (CachableQuery)o;
            if (!Objects.equals(this.queryString, that.queryString)) {
                return false;
            }
            return Objects.equals(this.sort, that.sort);
        }

        public int hashCode() {
            int result = this.queryString != null ? this.queryString.hashCode() : 0;
            result = 31 * result + (this.sort != null ? this.sort.hashCode() : 0);
            return result;
        }
    }

    class CachingQuerySortRewriter
    implements QuerySortRewriter {
        private final ConcurrentLruCache<CachableQuery, String> queryCache = new ConcurrentLruCache(16, abstractStringBasedJpaQuery::applySorting);
        private volatile String cachedQueryString;

        CachingQuerySortRewriter() {
        }

        @Override
        public String getSorted(DeclaredQuery query, Sort sort, ReturnedType returnedType) {
            if (sort.isUnsorted()) {
                String cachedQueryString = this.cachedQueryString;
                if (cachedQueryString == null) {
                    this.cachedQueryString = cachedQueryString = (String)this.queryCache.get((Object)new CachableQuery(query, sort, returnedType));
                }
                return cachedQueryString;
            }
            return (String)this.queryCache.get((Object)new CachableQuery(query, sort, returnedType));
        }
    }

    private static class NonProjectingReturnedType
    extends ReturnedType {
        private final ReturnedType delegate;

        NonProjectingReturnedType(ReturnedType delegate) {
            super(delegate.getDomainType());
            this.delegate = delegate;
        }

        public boolean isProjecting() {
            return false;
        }

        public Class<?> getReturnedType() {
            return this.delegate.getReturnedType();
        }

        public boolean needsCustomConstruction() {
            return false;
        }

        @Nullable
        public Class<?> getTypeToRead() {
            return this.delegate.getTypeToRead();
        }

        public List<String> getInputProperties() {
            return this.delegate.getInputProperties();
        }
    }

    static interface QuerySortRewriter {
        public String getSorted(DeclaredQuery var1, Sort var2, ReturnedType var3);
    }

    static enum SimpleQuerySortRewriter implements QuerySortRewriter
    {
        INSTANCE;


        @Override
        public String getSorted(DeclaredQuery query, Sort sort, ReturnedType returnedType) {
            return QueryEnhancerFactory.forQuery(query).rewrite(new DefaultQueryRewriteInformation(sort, returnedType));
        }
    }

    static class UnsortedCachingQuerySortRewriter
    implements QuerySortRewriter {
        private volatile String cachedQueryString;

        UnsortedCachingQuerySortRewriter() {
        }

        @Override
        public String getSorted(DeclaredQuery query, Sort sort, ReturnedType returnedType) {
            if (sort.isSorted()) {
                throw new UnsupportedOperationException("NoOpQueryCache does not support sorting");
            }
            String cachedQueryString = this.cachedQueryString;
            if (cachedQueryString == null) {
                this.cachedQueryString = cachedQueryString = QueryEnhancerFactory.forQuery(query).rewrite(new DefaultQueryRewriteInformation(sort, returnedType));
            }
            return cachedQueryString;
        }
    }
}

