/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.From;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.query.KeysetScrollDelegate;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.lang.Nullable;

public record KeysetScrollSpecification<T>(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) implements Specification<T>
{
    public KeysetScrollSpecification(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) {
        this.position = position;
        this.entity = entity;
        this.sort = KeysetScrollSpecification.createSort(position, sort, entity);
    }

    public static Sort createSort(KeysetScrollPosition position, Sort sort, JpaEntityInformation<?, ?> entity) {
        ArrayList<Object> sortById;
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(position.getDirection());
        if (entity.hasCompositeId()) {
            sortById = new ArrayList<String>(entity.getIdAttributeNames());
        } else {
            sortById = new ArrayList(1);
            sortById.add(entity.getRequiredIdAttribute().getName());
        }
        sort.forEach(it -> sortById.remove(it.getProperty()));
        Sort sortToUse = sortById.isEmpty() ? sort : sort.and(Sort.by((String[])sortById.toArray(new String[0])));
        return delegate.getSortOrders(sortToUse);
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        return this.createPredicate(root, criteriaBuilder);
    }

    @Nullable
    public Predicate createPredicate(Root<?> root, CriteriaBuilder criteriaBuilder) {
        KeysetScrollDelegate delegate = KeysetScrollDelegate.of(this.position.getDirection());
        return delegate.createPredicate(this.position, this.sort, new JpaQueryStrategy((From<?, ?>)root, criteriaBuilder));
    }

    private static class JpaQueryStrategy
    implements KeysetScrollDelegate.QueryStrategy<Expression<Comparable>, Predicate> {
        private final From<?, ?> from;
        private final CriteriaBuilder cb;

        public JpaQueryStrategy(From<?, ?> from, CriteriaBuilder cb) {
            this.from = from;
            this.cb = cb;
        }

        @Override
        public Expression<Comparable> createExpression(String property) {
            PropertyPath path = PropertyPath.from((String)property, (Class)this.from.getJavaType());
            return QueryUtils.toExpressionRecursively(this.from, path);
        }

        @Override
        public Predicate compare(Sort.Order order, Expression<Comparable> propertyExpression, Object value) {
            return order.isAscending() ? this.cb.greaterThan(propertyExpression, (Comparable)value) : this.cb.lessThan(propertyExpression, (Comparable)value);
        }

        @Override
        public Predicate compare(Expression<Comparable> propertyExpression, @Nullable Object value) {
            return value == null ? this.cb.isNull(propertyExpression) : this.cb.equal(propertyExpression, value);
        }

        @Override
        public Predicate and(List<Predicate> intermediate) {
            return this.cb.and(intermediate.toArray(new Predicate[0]));
        }

        @Override
        public Predicate or(List<Predicate> intermediate) {
            return this.cb.or(intermediate.toArray(new Predicate[0]));
        }
    }
}

