/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.JpaQueryParsingToken;
import org.springframework.data.jpa.repository.query.JpaQueryTransformerSupport;
import org.springframework.data.jpa.repository.query.JpqlParser;
import org.springframework.data.jpa.repository.query.JpqlQueryRenderer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JpqlQueryTransformer
extends JpqlQueryRenderer {
    private final Sort sort;
    private final boolean countQuery;
    @Nullable
    private final String countProjection;
    @Nullable
    private String primaryFromAlias = null;
    private List<JpaQueryParsingToken> projection = Collections.emptyList();
    private boolean projectionProcessed;
    private boolean hasConstructorExpression = false;
    private JpaQueryTransformerSupport transformerSupport;

    JpqlQueryTransformer() {
        this(Sort.unsorted(), false, null);
    }

    JpqlQueryTransformer(Sort sort) {
        this(sort, false, null);
    }

    JpqlQueryTransformer(boolean countQuery, @Nullable String countProjection) {
        this(Sort.unsorted(), countQuery, countProjection);
    }

    private JpqlQueryTransformer(Sort sort, boolean countQuery, @Nullable String countProjection) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        this.sort = sort;
        this.countQuery = countQuery;
        this.countProjection = countProjection;
        this.transformerSupport = new JpaQueryTransformerSupport();
    }

    @Nullable
    public String getAlias() {
        return this.primaryFromAlias;
    }

    public List<JpaQueryParsingToken> getProjection() {
        return this.projection;
    }

    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_statement(JpqlParser.Select_statementContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = JpqlQueryTransformer.newArrayList();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.select_clause()));
        tokens.addAll((Collection)this.visit((ParseTree)ctx.from_clause()));
        if (ctx.where_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.where_clause()));
        }
        if (ctx.groupby_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.groupby_clause()));
        }
        if (ctx.having_clause() != null) {
            tokens.addAll((Collection)this.visit((ParseTree)ctx.having_clause()));
        }
        if (!this.countQuery) {
            if (ctx.orderby_clause() != null) {
                tokens.addAll((Collection)this.visit((ParseTree)ctx.orderby_clause()));
            }
            if (this.sort.isSorted()) {
                if (ctx.orderby_clause() != null) {
                    JpaQueryParsingToken.NOSPACE(tokens);
                    tokens.add(JpaQueryParsingToken.TOKEN_COMMA);
                } else {
                    JpaQueryParsingToken.SPACE(tokens);
                    tokens.add(JpaQueryParsingToken.TOKEN_ORDER_BY);
                }
                tokens.addAll(this.transformerSupport.generateOrderByArguments(this.primaryFromAlias, this.sort));
            }
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_clause(JpqlParser.Select_clauseContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = JpqlQueryTransformer.newArrayList();
        tokens.add(new JpaQueryParsingToken(ctx.SELECT()));
        if (this.countQuery) {
            tokens.add(JpaQueryParsingToken.TOKEN_COUNT_FUNC);
        }
        if (ctx.DISTINCT() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.DISTINCT()));
        }
        ArrayList<JpaQueryParsingToken> selectItemTokens = JpqlQueryTransformer.newArrayList();
        ctx.select_item().forEach(selectItemContext -> {
            selectItemTokens.addAll((Collection)this.visit((ParseTree)selectItemContext));
            JpaQueryParsingToken.NOSPACE(selectItemTokens);
            selectItemTokens.add(JpaQueryParsingToken.TOKEN_COMMA);
        });
        JpaQueryParsingToken.CLIP(selectItemTokens);
        JpaQueryParsingToken.SPACE(selectItemTokens);
        if (this.countQuery) {
            if (this.countProjection != null) {
                tokens.add(new JpaQueryParsingToken(this.countProjection));
            } else if (ctx.DISTINCT() != null) {
                if (selectItemTokens.stream().anyMatch(jpqlToken -> jpqlToken.getToken().contains("new"))) {
                    tokens.add(new JpaQueryParsingToken(() -> this.primaryFromAlias));
                } else {
                    tokens.addAll(selectItemTokens);
                }
            } else {
                tokens.add(new JpaQueryParsingToken(() -> this.primaryFromAlias));
            }
            JpaQueryParsingToken.NOSPACE(tokens);
            tokens.add(JpaQueryParsingToken.TOKEN_CLOSE_PAREN);
        } else {
            tokens.addAll(selectItemTokens);
        }
        if (!this.projectionProcessed) {
            this.projection = selectItemTokens;
            this.projectionProcessed = true;
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitSelect_item(JpqlParser.Select_itemContext ctx) {
        Object tokens = super.visitSelect_item(ctx);
        if (ctx.result_variable() != null) {
            this.transformerSupport.registerAlias(((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken());
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitRange_variable_declaration(JpqlParser.Range_variable_declarationContext ctx) {
        ArrayList<JpaQueryParsingToken> tokens = JpqlQueryTransformer.newArrayList();
        tokens.addAll((Collection)this.visit((ParseTree)ctx.entity_name()));
        if (ctx.AS() != null) {
            tokens.add(new JpaQueryParsingToken(ctx.AS()));
        }
        tokens.addAll((Collection)this.visit((ParseTree)ctx.identification_variable()));
        if (this.primaryFromAlias == null) {
            this.primaryFromAlias = ((JpaQueryParsingToken)tokens.get(tokens.size() - 1)).getToken();
        }
        return tokens;
    }

    @Override
    public List<JpaQueryParsingToken> visitConstructor_expression(JpqlParser.Constructor_expressionContext ctx) {
        this.hasConstructorExpression = true;
        return super.visitConstructor_expression(ctx);
    }

    private static <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }
}

