/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.Date;
import java.util.function.Function;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query, values) -> {};

    public void setParameter(Query var1, Object[] var2);

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private final Function<Object[], Object> valueExtractor;
        private final Parameter<?> parameter;
        @Nullable
        private final TemporalType temporalType;

        NamedOrIndexedQueryParameterSetter(Function<Object[], Object> valueExtractor, Parameter<?> parameter, @Nullable TemporalType temporalType) {
            Assert.notNull(valueExtractor, (String)"ValueExtractor must not be null!");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
        }

        @Override
        public void setParameter(Query query, Object[] values) {
            Object value = this.valueExtractor.apply(values);
            if (this.temporalType != null) {
                if (this.parameter instanceof ParameterExpression) {
                    query.setParameter(this.parameter, (Date)value, this.temporalType);
                } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                    query.setParameter(this.parameter.getName(), (Date)value, this.temporalType);
                } else if (query.getParameters().size() >= this.parameter.getPosition() || this.registerExcessParameters(query)) {
                    query.setParameter(this.parameter.getPosition().intValue(), (Date)value, this.temporalType);
                }
            } else if (this.parameter instanceof ParameterExpression) {
                query.setParameter(this.parameter, value);
            } else if (this.parameter.getName() != null && QueryUtils.hasNamedParameter(query)) {
                query.setParameter(this.parameter.getName(), value);
            } else if (query.getParameters().size() >= this.parameter.getPosition() || this.registerExcessParameters(query)) {
                query.setParameter(this.parameter.getPosition().intValue(), value);
            }
        }

        private boolean registerExcessParameters(Query query) {
            return query.getParameters().size() == 0 && query.getClass().getName().startsWith("org.eclipse");
        }
    }
}

