/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.JdbcAggregateTemplate;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.support.BeanFactoryAwareRowMapperFactory;
import org.springframework.data.jdbc.repository.support.DefaultRowMapperFactory;
import org.springframework.data.jdbc.repository.support.JdbcQueryLookupStrategy;
import org.springframework.data.jdbc.repository.support.SimpleJdbcRepository;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.repository.query.RelationalEntityInformation;
import org.springframework.data.relational.repository.support.MappingRelationalEntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class JdbcRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationEventPublisherAware {
    private final JdbcAggregateOperations operations;
    private @Nullable BeanFactory beanFactory;
    private QueryMappingConfiguration queryMappingConfiguration = QueryMappingConfiguration.EMPTY;

    public JdbcRepositoryFactory(JdbcAggregateOperations operations) {
        Assert.notNull((Object)operations, (String)"JdbcAggregateOperations must not be null");
        this.operations = operations;
    }

    @Deprecated(since="4.0", forRemoval=true)
    public JdbcRepositoryFactory(DataAccessStrategy dataAccessStrategy, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, ApplicationEventPublisher publisher, NamedParameterJdbcOperations jdbcOperations) {
        Assert.notNull((Object)dataAccessStrategy, (String)"DataAccessStrategy must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"RelationalConverter must not be null");
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)jdbcOperations, (String)"NamedParameterJdbcOperations must not be null");
        this.operations = new JdbcAggregateTemplate(publisher, context, converter, dataAccessStrategy);
    }

    @Deprecated(since="4.0", forRemoval=true)
    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
    }

    @Deprecated(since="4.0", forRemoval=true)
    public void setEntityCallbacks(EntityCallbacks entityCallbacks) {
        Assert.notNull((Object)entityCallbacks, (String)"EntityCallbacks must not be null");
    }

    public void setBeanFactory(@Nullable BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setQueryMappingConfiguration(QueryMappingConfiguration queryMappingConfiguration) {
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        this.queryMappingConfiguration = queryMappingConfiguration;
    }

    public RelationalEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        RelationalPersistentEntity entity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(metadata.getDomainType());
        return new MappingRelationalEntityInformation(entity);
    }

    private RelationalMappingContext getMappingContext() {
        return this.operations.getConverter().getMappingContext();
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.getMappingContext().getRequiredPersistentEntity(repositoryInformation.getDomainType());
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{this.operations, persistentEntity, this.operations.getConverter()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleJdbcRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        DefaultRowMapperFactory rowMapperFactory = this.beanFactory != null ? new BeanFactoryAwareRowMapperFactory(this.beanFactory, this.operations, this.queryMappingConfiguration) : new DefaultRowMapperFactory(this.operations, this.queryMappingConfiguration);
        return Optional.of(JdbcQueryLookupStrategy.create(key, this.operations, rowMapperFactory, (ValueExpressionDelegate)new CachingValueExpressionDelegate(valueExpressionDelegate)));
    }
}

