/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.jdbc.repository.query.StatementFactory;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalQueryCreator;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.util.Assert;

public class JdbcQueryCreator
extends RelationalQueryCreator<ParametrizedQuery> {
    private final RelationalMappingContext context;
    private final PartTree tree;
    private final RelationalParameterAccessor accessor;
    private final RelationalEntityMetadata<?> entityMetadata;
    private final boolean isSliceQuery;
    private final ReturnedType returnedType;
    private final Optional<Lock> lockMode;
    private final StatementFactory statementFactory;

    @Deprecated(since="4.0", forRemoval=true)
    JdbcQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, boolean isSliceQuery, ReturnedType returnedType, Optional<Lock> lockMode) {
        this(context, tree, converter, dialect, entityMetadata, accessor, isSliceQuery, returnedType, lockMode, new SqlGeneratorSource(context, converter, dialect));
    }

    public JdbcQueryCreator(PartTree tree, JdbcConverter converter, Dialect dialect, JdbcQueryMethod queryMethod, RelationalParameterAccessor accessor, ReturnedType returnedType) {
        this(converter.getMappingContext(), tree, converter, dialect, queryMethod.getEntityInformation(), accessor, queryMethod.isSliceQuery(), returnedType, queryMethod.lookupLockAnnotation(), new SqlGeneratorSource(converter, dialect));
    }

    public JdbcQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, boolean isSliceQuery, ReturnedType returnedType, Optional<Lock> lockMode, SqlGeneratorSource sqlGeneratorSource) {
        super(tree, accessor);
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(entityMetadata, (String)"Relational entity metadata must not be null");
        Assert.notNull((Object)returnedType, (String)"ReturnedType must not be null");
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        this.context = context;
        this.tree = tree;
        this.accessor = accessor;
        this.entityMetadata = entityMetadata;
        this.isSliceQuery = isSliceQuery;
        this.returnedType = returnedType;
        this.lockMode = lockMode;
        this.statementFactory = new StatementFactory(converter, dialect);
    }

    StatementFactory getStatementFactory() {
        return this.statementFactory;
    }

    static void validate(PartTree tree, Parameters<?, ?> parameters, RelationalMappingContext context) {
        RelationalQueryCreator.validate((PartTree)tree, parameters);
        for (PartTree.OrPart parts : tree) {
            for (Part part : parts) {
                PersistentPropertyPath propertyPath = context.getPersistentPropertyPath(part.getProperty());
                AggregatePath path = context.getAggregatePath(propertyPath);
                path.forEach(JdbcQueryCreator::validateProperty);
            }
        }
    }

    private static void validateProperty(AggregatePath path) {
        if (path.isRoot()) {
            return;
        }
        if (!path.getParentPath().isEmbedded() && path.getLength() > 2) {
            throw new IllegalArgumentException(String.format("Cannot query by nested property: %s", path.toDotPath()));
        }
        if (path.isMultiValued() || path.isMap()) {
            throw new IllegalArgumentException(String.format("Cannot query by multi-valued property: %s", path.getRequiredLeafProperty().getName()));
        }
        if (!path.isEmbedded() && path.isEntity()) {
            throw new IllegalArgumentException(String.format("Cannot query by nested entity: %s", path.toDotPath()));
        }
    }

    protected ParametrizedQuery complete(@Nullable Criteria criteria, Sort sort) {
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        StatementFactory.SelectionBuilder selection = this.getSelection(entity);
        selection.page(this.accessor.getPageable()).filter(criteria).orderBy(sort);
        if (this.lockMode.isPresent()) {
            selection.lock(this.lockMode.get().value());
        }
        String sql = selection.build(parameterSource);
        return new ParametrizedQuery(sql, (SqlParameterSource)parameterSource, criteria != null ? criteria : Criteria.empty());
    }

    StatementFactory.SelectionBuilder getSelection(RelationalPersistentEntity<?> entity) {
        if (this.tree.isExistsProjection()) {
            return this.statementFactory.exists(entity);
        }
        if (this.tree.isCountProjection()) {
            return this.statementFactory.count(entity);
        }
        StatementFactory.SelectionBuilder selection = this.isSliceQuery ? this.statementFactory.slice(entity) : this.statementFactory.select(entity);
        if (this.returnedType.needsCustomConstruction()) {
            selection.project(this.returnedType.getInputProperties());
        }
        if (this.tree.isLimiting()) {
            selection.limit(this.tree.getResultLimit());
        }
        return selection;
    }
}

