/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Limit;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.repository.query.EscapingParameterSource;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.util.Predicates;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Contract;

public class StatementFactory {
    private final JdbcConverter converter;
    private final RenderContextFactory renderContextFactory;
    private final QueryMapper queryMapper;
    private final Dialect dialect;
    private final SqlGeneratorSource sqlGeneratorSource;

    public StatementFactory(JdbcConverter converter, Dialect dialect) {
        this.renderContextFactory = new RenderContextFactory(dialect);
        this.converter = converter;
        this.queryMapper = new QueryMapper(converter);
        this.dialect = dialect;
        this.sqlGeneratorSource = new SqlGeneratorSource(converter, dialect);
    }

    public SelectionBuilder select(Class<?> entity) {
        return this.select((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entity));
    }

    public SelectionBuilder select(RelationalPersistentEntity<?> entity) {
        return new SelectionBuilder(entity, SelectionBuilder.Mode.SELECT);
    }

    public SelectionBuilder count(Class<?> entity) {
        return this.count((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entity));
    }

    public SelectionBuilder count(RelationalPersistentEntity<?> entity) {
        return new SelectionBuilder(entity, SelectionBuilder.Mode.COUNT);
    }

    public SelectionBuilder exists(Class<?> entity) {
        return this.exists((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entity));
    }

    public SelectionBuilder exists(RelationalPersistentEntity<?> entity) {
        return new SelectionBuilder(entity, SelectionBuilder.Mode.EXISTS);
    }

    public SelectionBuilder slice(Class<?> entity) {
        return this.slice((RelationalPersistentEntity)this.converter.getMappingContext().getRequiredPersistentEntity(entity));
    }

    public SelectionBuilder slice(RelationalPersistentEntity<?> entity) {
        return new SelectionBuilder(entity, SelectionBuilder.Mode.SLICE);
    }

    public class SelectionBuilder {
        private final RelationalPersistentEntity<?> entity;
        private final Table table;
        private final Mode mode;
        private @Nullable LockMode lockMode;
        private Limit limit = Limit.unlimited();
        private Pageable pageable = Pageable.unpaged();
        private Sort sort = Sort.unsorted();
        private Criteria criteria = Criteria.empty();
        private List<String> properties = new ArrayList<String>();

        private SelectionBuilder(RelationalPersistentEntity<?> entity, Mode mode) {
            this.entity = entity;
            this.table = Table.create((SqlIdentifier)entity.getQualifiedTableName());
            this.mode = mode;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder project(Collection<String> properties) {
            this.properties = List.copyOf(properties);
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder project(String ... properties) {
            this.properties = Arrays.asList(properties);
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder orderBy(Sort sort) {
            this.sort = this.sort.and(sort);
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder page(@Nullable Pageable pageable) {
            if (pageable != null) {
                this.pageable = pageable;
                this.orderBy(pageable.getSort());
            }
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder limit(int limit) {
            this.limit = Limit.of((int)limit);
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder limit(Limit limit) {
            this.limit = limit;
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder filter(@Nullable Criteria criteria) {
            this.criteria = criteria == null ? Criteria.empty() : criteria;
            return this;
        }

        @Contract(value="_ -> this")
        public SelectionBuilder lock(LockMode lockMode) {
            this.lockMode = lockMode;
            return this;
        }

        public <T> T executeWith(StatementFunction<T> function) {
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            String sql = this.build(parameterSource);
            return function.apply(sql, new EscapingParameterSource((SqlParameterSource)parameterSource, StatementFactory.this.dialect.getLikeEscaper()));
        }

        public String build(MapSqlParameterSource parameterSource) {
            SelectBuilder.SelectLimitOffset limitOffsetBuilder = this.createSelectClause(this.entity, this.table);
            SelectBuilder.SelectWhere whereBuilder = this.applyLimitAndOffset(limitOffsetBuilder);
            SelectBuilder.SelectOrdered selectOrderBuilder = this.applyCriteria(this.criteria, this.entity, this.table, parameterSource, whereBuilder);
            SelectBuilder.SelectOrdered completedBuildSelect = selectOrderBuilder = this.applyOrderBy(this.sort, this.entity, this.table, selectOrderBuilder);
            if (this.lockMode != null) {
                completedBuildSelect = selectOrderBuilder.lock(this.lockMode);
            }
            Select select = completedBuildSelect.build();
            return SqlRenderer.create((RenderContext)StatementFactory.this.renderContextFactory.createRenderContext()).render(select);
        }

        SelectBuilder.SelectOrdered applyOrderBy(Sort sort, RelationalPersistentEntity<?> entity, Table table, SelectBuilder.SelectOrdered selectOrdered) {
            return sort.isSorted() ? selectOrdered.orderBy(StatementFactory.this.queryMapper.getMappedSort(table, sort, entity)) : selectOrdered;
        }

        SelectBuilder.SelectOrdered applyCriteria(@Nullable Criteria criteria, RelationalPersistentEntity<?> entity, Table table, MapSqlParameterSource parameterSource, SelectBuilder.SelectWhere whereBuilder) {
            return criteria != null && !criteria.isEmpty() ? whereBuilder.where(StatementFactory.this.queryMapper.getMappedObject(parameterSource, (CriteriaDefinition)criteria, table, entity)) : whereBuilder;
        }

        SelectBuilder.SelectWhere applyLimitAndOffset(SelectBuilder.SelectLimitOffset limitOffsetBuilder) {
            if (this.mode == Mode.COUNT) {
                return (SelectBuilder.SelectWhere)limitOffsetBuilder;
            }
            if (this.mode == Mode.EXISTS) {
                limitOffsetBuilder = limitOffsetBuilder.limit(1L);
            } else if (this.limit.isLimited()) {
                limitOffsetBuilder = limitOffsetBuilder.limit((long)this.limit.max());
            }
            if (this.pageable.isPaged()) {
                limitOffsetBuilder = limitOffsetBuilder.limit(this.mode == Mode.SLICE ? (long)(this.pageable.getPageSize() + 1) : (long)this.pageable.getPageSize()).offset(this.pageable.getOffset());
            }
            return (SelectBuilder.SelectWhere)limitOffsetBuilder;
        }

        SelectBuilder.SelectLimitOffset createSelectClause(RelationalPersistentEntity<?> entity, Table table) {
            Object builder;
            if (this.mode == Mode.EXISTS) {
                AggregatePath.ColumnInfo anyIdColumnInfo = StatementFactory.this.converter.getMappingContext().getAggregatePath(entity).getTableInfo().idColumnInfos().any();
                Column idColumn = table.column(anyIdColumnInfo.name());
                builder = Select.builder().select((Expression)idColumn).from((TableLike)table);
            } else {
                builder = this.mode == Mode.COUNT ? Select.builder().select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from((TableLike)table) : this.selectBuilder(table);
            }
            return (SelectBuilder.SelectLimitOffset)builder;
        }

        private SelectBuilder.SelectJoin selectBuilder(Table table) {
            Predicate<AggregatePath> filter = this.properties.isEmpty() ? Predicates.isFalse() : ap -> !this.properties.contains(ap.getRequiredBaseProperty().getName());
            return (SelectBuilder.SelectJoin)StatementFactory.this.sqlGeneratorSource.getSqlGenerator(this.entity.getType()).createSelectBuilder(table, filter);
        }

        static enum Mode {
            COUNT,
            EXISTS,
            SELECT,
            SLICE;

        }
    }

    @FunctionalInterface
    public static interface StatementFunction<T> {
        public T apply(String var1, SqlParameterSource var2);
    }
}

