/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMappingConfiguration;
import org.springframework.data.jdbc.repository.query.DefaultRowMapperFactory;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.PartTreeJdbcQuery;
import org.springframework.data.jdbc.repository.query.RowMapperFactory;
import org.springframework.data.jdbc.repository.query.StringBasedJdbcQuery;
import org.springframework.data.jdbc.repository.support.BeanFactoryAwareRowMapperFactory;
import org.springframework.data.mapping.callback.EntityCallbacks;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.repository.support.RelationalQueryLookupStrategy;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class JdbcQueryLookupStrategy
extends RelationalQueryLookupStrategy {
    private static final Log LOG = LogFactory.getLog(JdbcQueryLookupStrategy.class);
    private final ApplicationEventPublisher publisher;
    private final RelationalMappingContext context;
    @Nullable
    private final EntityCallbacks callbacks;
    private final JdbcConverter converter;
    private final QueryMappingConfiguration queryMappingConfiguration;
    private final NamedParameterJdbcOperations operations;
    protected final ValueExpressionDelegate delegate;

    JdbcQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, ValueExpressionDelegate delegate) {
        super((MappingContext)context, dialect);
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        this.context = context;
        this.publisher = publisher;
        this.callbacks = callbacks;
        this.converter = converter;
        this.queryMappingConfiguration = queryMappingConfiguration;
        this.operations = operations;
        this.delegate = delegate;
    }

    public RelationalMappingContext getMappingContext() {
        return this.context;
    }

    JdbcQueryMethod getJdbcQueryMethod(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
        return new JdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries, (MappingContext<? extends RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty>)this.getMappingContext());
    }

    public static QueryLookupStrategy create(@Nullable QueryLookupStrategy.Key key, ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanFactory, ValueExpressionDelegate delegate) {
        Assert.notNull((Object)publisher, (String)"ApplicationEventPublisher must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContextPublisher must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)queryMappingConfiguration, (String)"QueryMappingConfiguration must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        Assert.notNull((Object)delegate, (String)"ValueExpressionDelegate must not be null");
        CreateQueryLookupStrategy createQueryLookupStrategy = new CreateQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, delegate);
        DeclaredQueryLookupStrategy declaredQueryLookupStrategy = new DeclaredQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, beanFactory, delegate);
        QueryLookupStrategy.Key keyToUse = key != null ? key : QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND;
        LOG.debug((Object)String.format("Using the queryLookupStrategy %s", keyToUse));
        return switch (keyToUse) {
            default -> throw new IncompatibleClassChangeError();
            case QueryLookupStrategy.Key.CREATE -> createQueryLookupStrategy;
            case QueryLookupStrategy.Key.USE_DECLARED_QUERY -> declaredQueryLookupStrategy;
            case QueryLookupStrategy.Key.CREATE_IF_NOT_FOUND -> new CreateIfNotFoundQueryLookupStrategy(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, createQueryLookupStrategy, declaredQueryLookupStrategy, delegate);
        };
    }

    JdbcConverter getConverter() {
        return this.converter;
    }

    NamedParameterJdbcOperations getOperations() {
        return this.operations;
    }

    QueryMappingConfiguration getQueryMappingConfiguration() {
        return this.queryMappingConfiguration;
    }

    EntityCallbacks getCallbacks() {
        return this.callbacks;
    }

    ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    static class CreateQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        private final RowMapperFactory rowMapperFactory = new DefaultRowMapperFactory(this.getMappingContext(), this.getConverter(), this.getQueryMappingConfiguration(), this.getCallbacks(), this.getPublisher());

        CreateQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, ValueExpressionDelegate delegate) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, delegate);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            return new PartTreeJdbcQuery(this.getMappingContext(), queryMethod, this.getDialect(), this.getConverter(), this.getOperations(), this.rowMapperFactory);
        }
    }

    static class DeclaredQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        private final RowMapperFactory rowMapperFactory;

        DeclaredQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, @Nullable BeanFactory beanfactory, ValueExpressionDelegate delegate) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, delegate);
            this.rowMapperFactory = new BeanFactoryAwareRowMapperFactory(context, converter, queryMappingConfiguration, callbacks, publisher, beanfactory);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            JdbcQueryMethod queryMethod = this.getJdbcQueryMethod(method, repositoryMetadata, projectionFactory, namedQueries);
            if (namedQueries.hasQuery(queryMethod.getNamedQueryName()) || queryMethod.hasAnnotatedQuery()) {
                if (queryMethod.hasAnnotatedQuery() && queryMethod.hasAnnotatedQueryName()) {
                    LOG.warn((Object)String.format("Query method %s is annotated with both, a query and a query name; Using the declared query", method));
                }
                String queryString = this.evaluateTableExpressions(repositoryMetadata, queryMethod.getRequiredQuery());
                return new StringBasedJdbcQuery(queryString, queryMethod, this.getOperations(), this.rowMapperFactory, this.getConverter(), this.delegate);
            }
            throw new IllegalStateException(String.format("Did neither find a NamedQuery nor an annotated query for method %s", method));
        }
    }

    static class CreateIfNotFoundQueryLookupStrategy
    extends JdbcQueryLookupStrategy {
        private final DeclaredQueryLookupStrategy lookupStrategy;
        private final CreateQueryLookupStrategy createStrategy;

        CreateIfNotFoundQueryLookupStrategy(ApplicationEventPublisher publisher, @Nullable EntityCallbacks callbacks, RelationalMappingContext context, JdbcConverter converter, Dialect dialect, QueryMappingConfiguration queryMappingConfiguration, NamedParameterJdbcOperations operations, CreateQueryLookupStrategy createStrategy, DeclaredQueryLookupStrategy lookupStrategy, ValueExpressionDelegate delegate) {
            super(publisher, callbacks, context, converter, dialect, queryMappingConfiguration, operations, delegate);
            Assert.notNull((Object)((Object)createStrategy), (String)"CreateQueryLookupStrategy must not be null");
            Assert.notNull((Object)((Object)lookupStrategy), (String)"DeclaredQueryLookupStrategy must not be null");
            this.createStrategy = createStrategy;
            this.lookupStrategy = lookupStrategy;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata repositoryMetadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            try {
                return this.lookupStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
            catch (IllegalStateException e) {
                return this.createStrategy.resolveQuery(method, repositoryMetadata, projectionFactory, namedQueries);
            }
        }
    }
}

