/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.data.jdbc.repository.query.EscapingParameterSource;
import org.springframework.data.relational.core.dialect.Escaper;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

class ParametrizedQuery {
    private final String query;
    private final SqlParameterSource parameterSource;

    ParametrizedQuery(String query, SqlParameterSource parameterSource) {
        this.query = query;
        this.parameterSource = parameterSource;
    }

    String getQuery() {
        return this.query;
    }

    SqlParameterSource getParameterSource(Escaper escaper) {
        return new EscapingParameterSource(this.parameterSource, escaper);
    }

    public String toString() {
        return this.query;
    }
}

