/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.sql.SQLType;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.jdbc.core.convert.JdbcColumnTypes;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.relational.repository.query.RelationalParameters;
import org.springframework.data.repository.query.ParametersSource;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;

public class JdbcParameters
extends RelationalParameters {
    public JdbcParameters(ParametersSource parametersSource) {
        super(parametersSource, methodParameter -> new JdbcParameter((MethodParameter)methodParameter, (TypeInformation<?>)parametersSource.getDomainTypeInformation()));
    }

    private JdbcParameters(List<JdbcParameter> parameters) {
        super(parameters);
    }

    public JdbcParameter getParameter(int index) {
        return (JdbcParameter)super.getParameter(index);
    }

    protected JdbcParameters createFrom(List<RelationalParameters.RelationalParameter> parameters) {
        return new JdbcParameters(parameters);
    }

    public static class JdbcParameter
    extends RelationalParameters.RelationalParameter {
        private final SQLType sqlType;
        private final Lazy<SQLType> actualSqlType;

        JdbcParameter(MethodParameter parameter, TypeInformation<?> domainType) {
            super(parameter, domainType);
            TypeInformation typeInformation = this.getTypeInformation();
            this.sqlType = JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(typeInformation.getType()));
            this.actualSqlType = Lazy.of(() -> JdbcUtil.targetSqlTypeFor(JdbcColumnTypes.INSTANCE.resolvePrimitiveType(typeInformation.getActualType().getType())));
        }

        public SQLType getSqlType() {
            return this.sqlType;
        }

        public SQLType getActualSqlType() {
            return (SQLType)this.actualSqlType.get();
        }
    }
}

