/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.ResultSetAccessor;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.RowMapper;

class MapEntityRowMapper<T>
implements RowMapper<Map.Entry<Object, T>> {
    private final PersistentPropertyPathExtension path;
    private final JdbcConverter converter;
    private final Identifier identifier;
    private final SqlIdentifier keyColumn;

    MapEntityRowMapper(PersistentPropertyPathExtension path, JdbcConverter converter, Identifier identifier, SqlIdentifier keyColumn) {
        this.path = path;
        this.converter = converter;
        this.identifier = identifier;
        this.keyColumn = keyColumn;
    }

    public Map.Entry<Object, T> mapRow(ResultSet rs, int rowNum) throws SQLException {
        Object key = new ResultSetAccessor(rs).getObject(this.keyColumn.getReference());
        Class qualifierColumnType = ((RelationalPersistentProperty)this.path.getRequiredPersistentPropertyPath().getLeafProperty()).getQualifierColumnType();
        Object convertedKey = this.converter.readValue(key, TypeInformation.of((Class)qualifierColumnType));
        return new AbstractMap.SimpleEntry<Object, T>(convertedKey, this.mapEntity(rs, key));
    }

    private T mapEntity(ResultSet resultSet, Object key) {
        return this.converter.mapRow(this.path, resultSet, this.identifier, key);
    }
}

