/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.mapping;

import java.util.Optional;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.mapping.model.PersistentPropertyAccessorFactory;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.mapping.Table;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;

class RelationalPersistentEntityImpl<T>
extends BasicPersistentEntity<T, RelationalPersistentProperty>
implements RelationalPersistentEntity<T> {
    private final NamingStrategy namingStrategy;
    private final Lazy<Optional<String>> tableName;

    RelationalPersistentEntityImpl(TypeInformation<T> information, NamingStrategy namingStrategy) {
        super(information);
        this.namingStrategy = namingStrategy;
        this.tableName = Lazy.of(() -> Optional.ofNullable(this.findAnnotation(Table.class)).map(Table::value));
    }

    @Override
    public String getTableName() {
        return ((Optional)this.tableName.get()).orElseGet(() -> this.namingStrategy.getQualifiedTableName(this.getType()));
    }

    @Override
    public String getIdColumn() {
        return ((RelationalPersistentProperty)this.getRequiredIdProperty()).getColumnName();
    }

    public String toString() {
        return String.format("JdbcPersistentEntityImpl<%s>", this.getType());
    }

    public void setPersistentPropertyAccessorFactory(PersistentPropertyAccessorFactory factory) {
    }
}

