/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core;

import java.util.Map;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.util.Assert;

public class DelegatingDataAccessStrategy
implements DataAccessStrategy {
    private DataAccessStrategy delegate;

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Map<String, Object> additionalParameters) {
        return this.delegate.insert(instance, domainType, additionalParameters);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        return this.delegate.update(instance, domainType);
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.delegate.delete(rootId, propertyPath);
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        this.delegate.delete(id, domainType);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.delegate.deleteAll(domainType);
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.delegate.deleteAll(propertyPath);
    }

    @Override
    public long count(Class<?> domainType) {
        return this.delegate.count(domainType);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        Assert.notNull((Object)this.delegate, (String)"Delegate is null");
        return this.delegate.findById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.delegate.findAll(domainType);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        return this.delegate.findAllById(ids, domainType);
    }

    @Override
    public <T> Iterable<T> findAllByProperty(Object rootId, RelationalPersistentProperty property) {
        Assert.notNull((Object)this.delegate, (String)"Delegate is null");
        return this.delegate.findAllByProperty(rootId, property);
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        return this.delegate.existsById(id, domainType);
    }

    public void setDelegate(DataAccessStrategy delegate) {
        Assert.isNull((Object)this.delegate, (String)"The delegate must be set exactly once");
        Assert.notNull((Object)delegate, (String)"The delegate must not be set to null");
        this.delegate = delegate;
    }
}

