/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config;

import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class NamespaceUtils {
    static final String REF_ATTRIBUTE = "ref";

    static boolean isReference(String attributeName) {
        return attributeName.endsWith("-ref");
    }

    public static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyValue(propertyName, (Object)attr);
        }
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attrName) {
        NamespaceUtils.setPropertyValue(element, builder, attrName, Conventions.attributeNameToPropertyName((String)attrName));
    }

    static boolean setPropertyReference(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            builder.addPropertyReference(propertyName, attr);
            return true;
        }
        return false;
    }

    static boolean setPropertyReference(Element element, BeanDefinitionBuilder builder, String attrName) {
        return NamespaceUtils.setPropertyReference(element, builder, attrName, Conventions.attributeNameToPropertyName((String)(NamespaceUtils.isReference(attrName) ? attrName.substring(0, attrName.length() - 4) : attrName)));
    }

    public static boolean setCSVProperty(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            String[] strs = StringUtils.commaDelimitedListToStringArray((String)attr);
            ManagedList list = new ManagedList(strs.length);
            for (int i = 0; i < strs.length; ++i) {
                list.add((Object)strs[i].trim());
            }
            builder.addPropertyValue(propertyName, (Object)list);
            return true;
        }
        return false;
    }

    public static boolean setCSVReferenceProperty(Element element, BeanDefinitionBuilder builder, String attrName, String propertyName) {
        String attr = element.getAttribute(attrName);
        if (StringUtils.hasText((String)attr)) {
            String[] strs = StringUtils.commaDelimitedListToStringArray((String)attr);
            ManagedList list = new ManagedList(strs.length);
            for (int i = 0; i < strs.length; ++i) {
                list.add((Object)new RuntimeBeanReference(strs[i].trim()));
            }
            builder.addPropertyValue(propertyName, (Object)list);
            return true;
        }
        return false;
    }

    static boolean setCSVProperty(Element element, BeanDefinitionBuilder builder, String attrName) {
        return NamespaceUtils.setCSVProperty(element, builder, attrName, attrName);
    }
}

