/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.Collection;
import org.apache.hadoop.hive.service.HiveClient;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.hadoop.hive.HiveClientFactory;
import org.springframework.data.hadoop.hive.HiveScript;
import org.springframework.data.hadoop.hive.HiveUtils;
import org.springframework.util.CollectionUtils;

public class HiveClientFactoryBean
implements FactoryBean<HiveClientFactory> {
    private Collection<HiveScript> scripts;
    private String host = "localhost";
    private int port = 10000;
    private int timeout = 0;

    public HiveClientFactory getObject() {
        return new DefaultHiveClientFactory();
    }

    public Class<?> getObjectType() {
        return HiveClientFactory.class;
    }

    public boolean isSingleton() {
        return true;
    }

    protected HiveClient createHiveClient() {
        TSocket transport = new TSocket(this.host, this.port, this.timeout);
        HiveClient hive = new HiveClient((TProtocol)new TBinaryProtocol((TTransport)transport));
        try {
            transport.open();
            if (!CollectionUtils.isEmpty(this.scripts)) {
                HiveUtils.runWithConversion(hive, this.scripts, false);
            }
        }
        catch (TTransportException ex) {
            throw HiveUtils.convert((Exception)((Object)ex));
        }
        return hive;
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setScripts(Collection<HiveScript> scripts) {
        this.scripts = scripts;
    }

    private class DefaultHiveClientFactory
    implements HiveClientFactory {
        private DefaultHiveClientFactory() {
        }

        @Override
        public HiveClient getHiveClient() throws BeansException {
            try {
                return HiveClientFactoryBean.this.createHiveClient();
            }
            catch (Exception ex) {
                throw new BeanCreationException("Cannot create HiveClient instance", (Throwable)ex);
            }
        }
    }
}

