/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.util.LinkedHashSet;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.springframework.data.hadoop.hbase.HbaseAccessor;
import org.springframework.data.hadoop.hbase.HbaseSynchronizationManager;
import org.springframework.data.hadoop.hbase.HbaseUtils;
import org.springframework.util.Assert;

public class HbaseInterceptor
extends HbaseAccessor
implements MethodInterceptor {
    private static final Log log = LogFactory.getLog(HbaseInterceptor.class);
    private boolean exceptionConversionEnabled = true;
    private String[] tableNames;

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.notEmpty((Object[])this.tableNames, (String)"at least one table needs to be specified");
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        LinkedHashSet<String> boundTables = new LinkedHashSet<String>();
        for (String tableName : this.tableNames) {
            if (HbaseSynchronizationManager.hasResource(tableName)) continue;
            boundTables.add(tableName);
            HTableInterface table = HbaseUtils.getHTable(tableName, this.getConfiguration(), this.getCharset(), this.getTableFactory());
            HbaseSynchronizationManager.bindResource(tableName, table);
        }
        try {
            Object retVal;
            Object object = retVal = methodInvocation.proceed();
            return object;
        }
        catch (Exception ex) {
            if (this.exceptionConversionEnabled) {
                throw this.convertHBaseException(ex);
            }
            throw ex;
        }
        finally {
            for (String tableName : boundTables) {
                HTableInterface table = (HTableInterface)HbaseSynchronizationManager.unbindResourceIfPossible(tableName);
                if (table != null) {
                    HbaseUtils.releaseTable(tableName, table);
                    continue;
                }
                log.warn((Object)("Table [" + tableName + "] unbound from the thread by somebody else; cannot guarantee proper clean-up"));
            }
        }
    }

    private Exception convertHBaseException(Exception ex) {
        return HbaseUtils.convertHbaseException(ex);
    }

    public void setTableNames(String[] tableNames) {
        this.tableNames = tableNames;
    }

    public void setExceptionConversionEnabled(boolean exceptionConversionEnabled) {
        this.exceptionConversionEnabled = exceptionConversionEnabled;
    }
}

