/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import org.apache.geode.cache.GemFireCache;
import org.springframework.core.io.Resource;
import org.springframework.data.gemfire.AbstractBasicCacheFactoryBean;
import org.springframework.data.gemfire.support.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public abstract class AbstractConfigurableCacheFactoryBean
extends AbstractBasicCacheFactoryBean {
    private boolean useBeanFactoryLocator = false;
    private GemfireBeanFactoryLocator beanFactoryLocator;
    private Properties properties;
    private Resource cacheXml;

    protected void setBeanFactoryLocator(@Nullable GemfireBeanFactoryLocator beanFactoryLocator) {
        this.beanFactoryLocator = beanFactoryLocator;
    }

    @Nullable
    public GemfireBeanFactoryLocator getBeanFactoryLocator() {
        return this.beanFactoryLocator;
    }

    public Optional<GemfireBeanFactoryLocator> getOptionalBeanFactoryLocator() {
        return Optional.ofNullable(this.getBeanFactoryLocator());
    }

    public void setCacheXml(@Nullable Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    @Nullable
    public Resource getCacheXml() {
        return this.cacheXml;
    }

    public Optional<Resource> getOptionalCacheXml() {
        return Optional.ofNullable(this.getCacheXml());
    }

    protected boolean isCacheXmlPresent() {
        return this.getOptionalCacheXml().filter(Resource::exists).isPresent();
    }

    protected boolean isCacheXmlResolvableAsAFile() {
        return this.getOptionalCacheXml().filter(Resource::isFile).isPresent();
    }

    @Nullable
    public Properties setAndGetProperties(@Nullable Properties properties) {
        this.setProperties(properties);
        return this.getProperties();
    }

    public void setProperties(@Nullable Properties properties) {
        this.properties = properties;
    }

    @Nullable
    public Properties getProperties() {
        return this.properties;
    }

    public void setUseBeanFactoryLocator(boolean use) {
        this.useBeanFactoryLocator = use;
    }

    public boolean isUseBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        if (this.useBeanFactoryLocator()) {
            this.setBeanFactoryLocator(GemfireBeanFactoryLocator.newBeanFactoryLocator(this.getBeanFactory(), this.getBeanName()));
        }
    }

    private boolean useBeanFactoryLocator() {
        return this.isUseBeanFactoryLocator() && !this.getOptionalBeanFactoryLocator().isPresent();
    }

    @Override
    public void destroy() {
        super.destroy();
        this.getOptionalBeanFactoryLocator().ifPresent(GemfireBeanFactoryLocator::destroy);
        this.setBeanFactoryLocator(null);
    }

    @NonNull
    protected <T extends GemFireCache> T loadCacheXml(@NonNull T cache) {
        this.getOptionalCacheXml().ifPresent(cacheXml -> {
            try {
                this.logDebug("Initializing cache with [%s]", cacheXml);
                cache.loadCacheXml(cacheXml.getInputStream());
            }
            catch (IOException cause) {
                throw RuntimeExceptionFactory.newRuntimeException(cause, "Failed to load cache.xml [%s]", cacheXml);
            }
        });
        return cache;
    }

    @NonNull
    protected Properties resolveProperties() {
        Properties properties = this.getProperties();
        return properties != null ? properties : this.setAndGetProperties(new Properties());
    }
}

