/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PropertiesBuilder
implements FactoryBean<Properties> {
    private static final Function<Object, String> TO_STRING_FUNCTION = target -> target instanceof Class ? ((Class)target).getName() : (target != null ? target.toString() : String.valueOf(target));
    private final Properties properties = new Properties();

    public static PropertiesBuilder create() {
        return new PropertiesBuilder();
    }

    public static PropertiesBuilder from(Properties properties) {
        return new PropertiesBuilder(properties);
    }

    public static PropertiesBuilder from(InputStream in) {
        try {
            Properties defaults = new Properties();
            defaults.load(in);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException cause) {
            throw new IllegalArgumentException("Failed to read properties from InputStream", cause);
        }
    }

    public static PropertiesBuilder from(Reader reader) {
        try {
            Properties defaults = new Properties();
            defaults.load(reader);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException cause) {
            throw new IllegalArgumentException("Failed to read properties from Reader", cause);
        }
    }

    public static PropertiesBuilder fromXml(InputStream xml) {
        try {
            Properties defaults = new Properties();
            defaults.loadFromXML(xml);
            return new PropertiesBuilder(defaults);
        }
        catch (IOException cause) {
            throw new IllegalArgumentException("Failed to read properties from XML", cause);
        }
    }

    public PropertiesBuilder() {
    }

    public PropertiesBuilder(Properties defaults) {
        this.properties.putAll((Map<?, ?>)defaults);
    }

    public PropertiesBuilder(PropertiesBuilder builder) {
        this(builder.build());
    }

    @NonNull
    public Properties getObject() throws Exception {
        return this.build();
    }

    @NonNull
    public Class<?> getObjectType() {
        return this.properties != null ? this.properties.getClass() : Properties.class;
    }

    public boolean isSingleton() {
        return true;
    }

    @NonNull
    public PropertiesBuilder add(@Nullable Properties properties) {
        if (!CollectionUtils.isEmpty((Map)properties)) {
            this.properties.putAll((Map<?, ?>)properties);
        }
        return this;
    }

    @NonNull
    public PropertiesBuilder add(@Nullable PropertiesBuilder builder) {
        return builder != null ? this.add(builder.build()) : this;
    }

    @NonNull
    public PropertiesBuilder setProperty(@NonNull String name, @NonNull Object value) {
        return value != null ? this.setProperty(name, TO_STRING_FUNCTION.apply(value)) : this;
    }

    @NonNull
    public PropertiesBuilder setProperty(@NonNull String name, @Nullable Object[] values) {
        return !ObjectUtils.isEmpty((Object[])values) ? this.setProperty(name, StringUtils.arrayToCommaDelimitedString((Object[])values)) : this;
    }

    @NonNull
    public PropertiesBuilder setProperty(@NonNull String name, @NonNull String value) {
        Assert.hasText((String)name, (String)String.format("Name [%s] must be specified", name));
        if (this.isValuable(value)) {
            this.properties.setProperty(name, value);
        }
        return this;
    }

    @NonNull
    public <T> PropertiesBuilder setPropertyIfNotDefault(@NonNull String name, Object value, T defaultValue) {
        return defaultValue == null || !defaultValue.equals(value) ? this.setProperty(name, value) : this;
    }

    @NonNull
    public PropertiesBuilder unsetProperty(@NonNull String name) {
        Assert.hasText((String)name, (String)String.format("Name [%s] mut be specified", name));
        this.properties.setProperty(name, "");
        return this;
    }

    protected boolean isValuable(@Nullable String value) {
        return StringUtils.hasText((String)value) && !"null".equalsIgnoreCase(value.trim());
    }

    @NonNull
    public Properties build() {
        return this.properties;
    }
}

